/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.cmp;

import com.sun.jdo.api.persistence.support.JDOFatalDataStoreException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOHelper;
import com.sun.jdo.api.persistence.support.JDOObjectNotFoundException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.spi.persistence.support.ejb.cmp.LogHelperEntityInternal;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.CMPHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.JDOEJB11Helper;
import com.sun.jdo.spi.persistence.support.sqlstore.utility.NumericConverter;
import com.sun.jdo.spi.persistence.support.sqlstore.utility.NumericConverterFactory;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.glassfish.persistence.common.I18NHelper;

public abstract class JDOEJB11HelperImpl
implements JDOEJB11Helper {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(JDOEJB11HelperImpl.class);
    protected static final Logger logger = LogHelperEntityInternal.getLogger();

    public EJBObject convertPCToEJBObject(Object pc, PersistenceManager pm) {
        if (pc == null) {
            return null;
        }
        Object jdoObjectId = pm.getObjectId(pc);
        Object key = this.convertObjectIdToPrimaryKey(jdoObjectId);
        try {
            return CMPHelper.getEJBObject((Object)key, (Object)this.getContainer());
        }
        catch (Exception ex) {
            EJBException e = new EJBException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_ConvertPCToEJBObject", (String)key.toString()), ex);
            logger.throwing("JDOEJB11HelperImpl", "convertPCToEJBObject", (Throwable)e);
            throw e;
        }
    }

    public Object convertEJBObjectToPC(EJBObject o, PersistenceManager pm, boolean validate) {
        Object key = null;
        try {
            key = o.getPrimaryKey();
        }
        catch (Exception ex) {
            EJBException e = new EJBException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_ConvertEJBObjectToPC", (String)o.getClass().getName()), ex);
            logger.throwing("JDOEJB11HelperImpl", "convertEJBObjectToPC", (Throwable)e);
            throw e;
        }
        return this.convertPrimaryKeyToPC(key, pm, validate);
    }

    protected Object convertPrimaryKeyToPC(Object key, PersistenceManager pm, boolean validate) {
        Object pc = null;
        try {
            Object jdoObjectId = this.convertPrimaryKeyToObjectId(key);
            pc = pm.getObjectById(jdoObjectId, validate);
        }
        catch (JDOObjectNotFoundException ex) {
            logger.fine("---JDOEJB11HelperImpl.convertPrimaryKeyToPC: Object not found for: " + key);
            throw new IllegalArgumentException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_DeletedInstanceOtherTx", (String)key.toString()));
        }
        if (validate && JDOHelper.isDeleted((Object)pc)) {
            logger.fine("---JDOEJB11HelperImpl.convertPrimaryKeyToPC: Object is deleted for: " + key);
            throw new IllegalArgumentException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_DeletedInstanceThisTx", (String)key.toString()));
        }
        return pc;
    }

    public Collection convertCollectionPCToEJBObject(Collection pcs, PersistenceManager pm) {
        ArrayList<EJBObject> rc = new ArrayList<EJBObject>();
        EJBObject o = null;
        Iterator it = pcs.iterator();
        while (it.hasNext()) {
            o = this.convertPCToEJBObject(it.next(), pm);
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionPCToEJBObject() adding: " + o);
            }
            rc.add(o);
        }
        return rc;
    }

    public Set convertCollectionPCToEJBObjectSet(Collection pcs, PersistenceManager pm) {
        HashSet<EJBObject> rc = new HashSet<EJBObject>();
        EJBObject o = null;
        Iterator it = pcs.iterator();
        while (it.hasNext()) {
            o = this.convertPCToEJBObject(it.next(), pm);
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionPCToEJBObjectSet() adding: " + o);
            }
            rc.add(o);
        }
        return rc;
    }

    public Collection convertCollectionEJBObjectToPC(Collection coll, PersistenceManager pm, boolean validate) {
        ArrayList<Object> rc = new ArrayList<Object>();
        Object o = null;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            o = this.convertEJBObjectToPC((EJBObject)it.next(), pm, validate);
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionEJBObjectToPC() adding: " + o);
            }
            rc.add(o);
        }
        return rc;
    }

    public Object convertPCToPrimaryKey(Object pc, PersistenceManager pm) {
        if (pc == null) {
            return null;
        }
        Object rc = this.convertObjectIdToPrimaryKey(pm.getObjectId(pc));
        if (logger.isLoggable(300)) {
            logger.finest("\n---JDOEJB11HelperImpl.convertPCToPrimaryKey() PK: " + rc);
        }
        return rc;
    }

    public Collection convertCollectionPCToPrimaryKey(Collection pcs, PersistenceManager pm) {
        ArrayList<Object> rc = new ArrayList<Object>();
        Object o = null;
        Iterator it = pcs.iterator();
        while (it.hasNext()) {
            o = this.convertPCToPrimaryKey(it.next(), pm);
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionPCToPrimaryKey() adding: " + o);
            }
            rc.add(o);
        }
        return rc;
    }

    public abstract Object convertObjectIdToPrimaryKey(Object var1);

    public abstract Object convertPrimaryKeyToObjectId(Object var1);

    public Collection convertCollectionObjectIdToPrimaryKey(Collection oids) {
        ArrayList<Object> rc = new ArrayList<Object>();
        Object o = null;
        Iterator it = oids.iterator();
        while (it.hasNext()) {
            o = this.convertObjectIdToPrimaryKey(it.next());
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionObjectIdToPrimaryKey() adding: " + o);
            }
            rc.add(o);
        }
        return rc;
    }

    public Collection convertCollectionPrimaryKeyToObjectId(Collection keys) {
        ArrayList<Object> rc = new ArrayList<Object>();
        Object o = null;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            o = this.convertPrimaryKeyToObjectId(it.next());
            if (logger.isLoggable(300)) {
                logger.finest("\n---JDOEJB11HelperImpl.convertCollectionPrimaryKeyToObjectId() adding: " + o);
            }
            rc.add(o);
        }
        return rc;
    }

    public byte[] writeSerializableObjectToByteArray(Serializable serializableObject) {
        byte[] byteArray = null;
        if (serializableObject != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(bos);
                oos.writeObject(serializableObject);
                byteArray = bos.toByteArray();
            }
            catch (IOException e) {
                String clsName = serializableObject.getClass().getName();
                throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_IOWriteSerializableObject", (String)clsName), (Exception)e);
            }
        }
        return byteArray;
    }

    public Serializable readSerializableObjectFromByteArray(byte[] byteArray) {
        Serializable serializableObject = null;
        if (byteArray != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
            HelperObjectInputStream ois = null;
            ClassLoader cl = this.getClass().getClassLoader();
            try {
                ois = new HelperObjectInputStream(bis, cl);
                serializableObject = (Serializable)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new JDOFatalDataStoreException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_CNFReadSerializableObject"), (Exception)e);
            }
            catch (IOException e) {
                throw new JDOFatalDataStoreException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_IOReadSerializableObject"), (Exception)e);
            }
        }
        return serializableObject;
    }

    public NumericConverter getNumericConverter() {
        int policy = CMPHelper.getNumericConverterPolicy((Object)this.getContainer());
        return NumericConverterFactory.getNumericConverter((int)policy);
    }

    public abstract Class getPCClass();

    public abstract void assertInstanceOfRemoteInterfaceImpl(Object var1);

    protected void assertInstanceOfRemoteInterfaceImpl(Object o, String beanName) {
        if (o == null) {
            return;
        }
        try {
            CMPHelper.assertValidRemoteObject((Object)o, (Object)this.getContainer());
        }
        catch (EJBException ex) {
            String msg = I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_WrongRemoteInstance", (Object[])new Object[]{o.getClass().getName(), beanName, ex.getMessage()});
            logger.log(900, msg);
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertPrimaryKeyNotNull(Object pk) {
        if (pk == null) {
            throw new IllegalArgumentException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_pknull_exception"));
        }
    }

    public void assertPrimaryKeyFieldNotNull(Object pkfield, String pkfieldName, String beanName) {
        if (pkfield == null) {
            throw new IllegalArgumentException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_pkfieldnull_exception", (String)pkfieldName, (String)beanName));
        }
    }

    protected void assertObjectIdNotNull(Object oid) {
        if (oid == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_oidnull_exception"));
        }
    }

    static class HelperObjectInputStream
    extends ObjectInputStream {
        ClassLoader classLoader;

        public HelperObjectInputStream(InputStream is, ClassLoader cl) throws IOException, StreamCorruptedException {
            super(is);
            this.classLoader = cl;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return Class.forName(v.getName(), true, this.classLoader);
        }
    }
}

