/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.ejb.entitybean.container;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.BaseContainerFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.security.SecurityManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.persistence.ejb.entitybean.container.CommitCEntityContainer;
import org.glassfish.persistence.ejb.entitybean.container.EntityContainer;
import org.glassfish.persistence.ejb.entitybean.container.ReadOnlyBeanContainer;
import org.jvnet.hk2.annotations.Service;

@Service(name="EntityContainerFactory")
@PerLookup
public final class EntityContainerFactory
extends BaseContainerFactory
implements PostConstruct,
ContainerFactory {
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    private EjbContainer ejbContainerDesc;
    private static final Logger _logger = LogDomains.getLogger(EntityContainerFactory.class, (String)"javax.enterprise.system.container.ejb");

    public void postConstruct() {
        this.ejbContainerDesc = (EjbContainer)this.serverConfig.getExtensionByType(EjbContainer.class);
    }

    public Container createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader, DeploymentContext deployContext) throws Exception {
        EntityContainer container = null;
        SecurityManager sm = this.getSecurityManager(ejbDescriptor);
        assert (ejbDescriptor instanceof EjbEntityDescriptor);
        if (((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
            container = new ReadOnlyBeanContainer(ejbDescriptor, loader, sm);
        } else {
            String commitOption = null;
            IASEjbExtraDescriptors iased = ((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors();
            if (iased != null) {
                commitOption = iased.getCommitOption();
            }
            if (commitOption == null) {
                commitOption = this.ejbContainerDesc.getCommitOption();
            }
            if (commitOption.equals("A")) {
                _logger.log(Level.WARNING, "entitybean.container.commit_option_A_not_supported", new Object[]{ejbDescriptor.getName()});
                container = new EntityContainer(ejbDescriptor, loader, sm);
            } else if (commitOption.equals("C")) {
                _logger.log(Level.FINE, "Using commit option C for: " + ejbDescriptor.getName());
                container = new CommitCEntityContainer(ejbDescriptor, loader, sm);
            } else {
                _logger.log(Level.FINE, "Using commit option B for: " + ejbDescriptor.getName());
                container = new EntityContainer(ejbDescriptor, loader, sm);
            }
        }
        ((EntityContainer)container).initializeHome();
        return container;
    }
}

