/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.ejb.entitybean.container.cache;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.LruCache;
import com.sun.ejb.containers.util.cache.LruEJBCache;
import com.sun.logging.LogDomains;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.persistence.ejb.entitybean.container.cache.EJBObjectCache;
import org.glassfish.persistence.ejb.entitybean.container.cache.EJBObjectCacheListener;

public class FIFOEJBObjectCache
extends LruEJBCache
implements EJBObjectCache {
    protected int maxCacheSize;
    protected String name;
    protected EJBObjectCacheListener listener;
    protected Object refCountLock = new Object();
    protected int totalRefCount = 0;
    protected static final boolean _printRefCount = Boolean.getBoolean("cache.printrefcount");
    private static final Logger _logger = LogDomains.getLogger(FIFOEJBObjectCache.class, (String)"jakarta.enterprise.system.container.ejb");

    public FIFOEJBObjectCache(String name) {
        this.name = name;
    }

    public FIFOEJBObjectCache(String name, long timeout) {
        this.setTimeout(timeout);
        this.name = name;
    }

    @Override
    public void init(int maxEntries, int numberOfVictimsToSelect, long timeout, float loadFactor, Properties props) {
        super.init(maxEntries, loadFactor, props);
        this.timeout = timeout;
        this.maxCacheSize = maxEntries;
        _logger.log(Level.FINE, this.name + ": FIFOEJBObject cache created....");
    }

    @Override
    public void setEJBObjectCacheListener(EJBObjectCacheListener listener) {
        this.listener = listener;
    }

    public Object get(Object key) {
        int hashCode = this.hash(key);
        return this.internalGet(hashCode, key, false);
    }

    @Override
    public Object get(Object key, boolean incrementRefCount) {
        int hashCode = this.hash(key);
        return this.internalGet(hashCode, key, incrementRefCount);
    }

    public Object put(Object key, Object value) {
        int hashCode = this.hash(key);
        return this.internalPut(hashCode, key, value, -1, false);
    }

    @Override
    public Object put(Object key, Object value, boolean incrementRefCount) {
        int hashCode = this.hash(key);
        return this.internalPut(hashCode, key, value, -1, incrementRefCount);
    }

    public Object remove(Object key) {
        return this.internalRemove(key, true);
    }

    @Override
    public Object remove(Object key, boolean decrementRefCount) {
        return this.internalRemove(key, decrementRefCount);
    }

    protected boolean isThresholdReached() {
        return this.listSize > this.maxCacheSize;
    }

    protected void itemAccessed(BaseCache.CacheItem item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRemoved(BaseCache.CacheItem item) {
        assert (item instanceof LruCache.LruCacheItem);
        LruCache.LruCacheItem l = (LruCache.LruCacheItem)item;
        FIFOEJBObjectCache fIFOEJBObjectCache = this;
        synchronized (fIFOEJBObjectCache) {
            if (l.isTrimmed()) {
                return;
            }
            LruCache.LruCacheItem prev = l.getLPrev();
            LruCache.LruCacheItem next = l.getLNext();
            l.setTrimmed(true);
            if (prev != null) {
                prev.setLNext(next);
            } else {
                this.head = next;
            }
            if (next != null) {
                next.setLPrev(prev);
            } else {
                this.tail = prev;
            }
            l.setLNext(null);
            l.setLPrev(null);
            --this.listSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalGet(int hashCode, Object key, boolean incrementRefCount) {
        int index = this.getIndex(hashCode);
        Object value = null;
        BaseCache.CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            for (item = this.buckets[index]; !(item == null || hashCode == item.getHashCode() && this.eq(key, item.getKey())); item = item.getNext()) {
            }
            if (item != null) {
                value = item.getValue();
                if (incrementRefCount) {
                    assert (item instanceof EJBObjectCacheItem);
                    EJBObjectCacheItem eoItem = (EJBObjectCacheItem)item;
                    ++eoItem.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                    if (!eoItem.isTrimmed()) {
                        this.itemRemoved((BaseCache.CacheItem)eoItem);
                    }
                }
            }
        }
        if (item != null) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalPut(int hashCode, Object key, Object value, int size, boolean incrementRefCount) {
        int index = this.getIndex(hashCode);
        BaseCache.CacheItem oldItem = null;
        BaseCache.CacheItem overflow = null;
        EJBObjectCacheItem newItem = null;
        Object oldValue = null;
        boolean oldSize = false;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            for (BaseCache.CacheItem item = this.buckets[index]; item != null; item = item.getNext()) {
                if (hashCode != item.getHashCode() || !this.eq(key, item.getKey())) continue;
                oldItem = item;
                break;
            }
            if (oldItem == null) {
                newItem = (EJBObjectCacheItem)this.createItem(hashCode, key, value, size);
                newItem.setTrimmed(incrementRefCount);
                newItem.setNext(this.buckets[index]);
                this.buckets[index] = newItem;
                if (incrementRefCount) {
                    ++newItem.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                } else {
                    overflow = this.itemAdded((BaseCache.CacheItem)newItem);
                }
            } else {
                oldValue = oldItem.getValue();
                if (incrementRefCount) {
                    assert (oldItem instanceof EJBObjectCacheItem);
                    EJBObjectCacheItem oldEJBO = (EJBObjectCacheItem)oldItem;
                    ++oldEJBO.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                }
            }
        }
        if (newItem != null) {
            this.incrementEntryCount();
            if (overflow != null && this.listener != null) {
                this.listener.handleOverflow(overflow.getKey());
            }
        }
        return oldValue;
    }

    public void print() {
        System.out.println("EJBObjectCache:: size: " + this.getEntryCount() + "; listSize: " + this.listSize);
        for (LruCache.LruCacheItem run = this.head; run != null; run = run.getLNext()) {
            System.out.print("(" + run.getKey() + ", " + run.getValue() + ") ");
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalRemove(Object key, boolean decrementRefCount) {
        int hashCode = this.hash(key);
        int index = this.getIndex(hashCode);
        BaseCache.CacheItem prev = null;
        BaseCache.CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            for (item = this.buckets[index]; item != null; item = item.getNext()) {
                if (hashCode == item.getHashCode() && key.equals(item.getKey())) {
                    assert (item instanceof EJBObjectCacheItem);
                    EJBObjectCacheItem eoItem = (EJBObjectCacheItem)item;
                    if (decrementRefCount && eoItem.refCount > 0) {
                        --eoItem.refCount;
                        if (_printRefCount) {
                            this.decrementReferenceCount();
                        }
                    }
                    if (eoItem.refCount > 0) {
                        return null;
                    }
                    if (prev == null) {
                        this.buckets[index] = item.getNext();
                    } else {
                        prev.setNext(item.getNext());
                    }
                    item.setNext(null);
                    this.itemRemoved(item);
                    break;
                }
                prev = item;
            }
        }
        if (item != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
            return item.getValue();
        }
        this.incrementMissCount();
        return null;
    }

    protected BaseCache.CacheItem createItem(int hashCode, Object key, Object value, int size) {
        return new EJBObjectCacheItem(hashCode, key, value, size);
    }

    public Map getStats() {
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("(totalRef=").append(this.totalRefCount).append("; ");
        sbuf.append("listSize=").append(this.listSize).append("; curSize/totSize=").append(this.getEntryCount()).append("/").append(this.maxEntries).append("; trim=").append(this.trimCount).append("; remove=").append(this.removalCount).append("; hit/miss=").append(this.hitCount).append("/").append(this.missCount).append(")");
        map.put((CallSite)((Object)("[" + this.name + "]")), sbuf.toString());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimExpiredEntries(int maxCount) {
        LruCache.LruCacheItem item;
        int count = 0;
        LruCache.LruCacheItem lastItem = null;
        long currentTime = System.currentTimeMillis();
        FIFOEJBObjectCache fIFOEJBObjectCache = this;
        synchronized (fIFOEJBObjectCache) {
            for (item = this.tail; item != null && count < maxCount && this.timeout != -1L && item.getLastAccessed() + this.timeout <= currentTime; ++count, item = item.getLPrev()) {
                item.setTrimmed(true);
                lastItem = item;
            }
            if (item != this.tail) {
                lastItem.setLPrev(null);
                if (item != null) {
                    item.setLNext(null);
                } else {
                    this.head = null;
                }
                lastItem = this.tail;
                this.tail = item;
            }
            this.listSize -= count;
            this.trimCount += count;
        }
        if (count > 0) {
            ArrayList<Object> localVictims = new ArrayList<Object>(count);
            for (item = lastItem; item != null; item = item.getLPrev()) {
                localVictims.add(item.getKey());
            }
            if (this.listener != null) {
                this.listener.handleBatchOverflow(localVictims);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementReferenceCount() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.totalRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementReferenceCount() {
        Object object = this.refCountLock;
        synchronized (object) {
            --this.totalRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementReferenceCount(int count) {
        Object object = this.refCountLock;
        synchronized (object) {
            this.totalRefCount -= count;
        }
    }

    public static void main(String[] args) {
    }

    protected static class EJBObjectCacheItem
    extends LruCache.LruCacheItem {
        protected int refCount;

        protected EJBObjectCacheItem(int hashCode, Object key, Object value, int size) {
            super(hashCode, key, value, size);
        }
    }
}

