/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpaconnector;

import java.io.IOException;
import java.util.Enumeration;
import javax.enterprise.deploy.shared.ModuleType;
import javax.inject.Singleton;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Service;

@Service(name="jpa")
@Singleton
public class JPASniffer
extends GenericSniffer {
    private static final String[] containers = new String[]{"org.glassfish.persistence.jpa.JPAContainer"};
    private static char SEPERATOR_CHAR = (char)47;
    private static final String WEB_INF = "WEB-INF";
    private static final String LIB = "lib";
    private static final String WEB_INF_LIB = "WEB-INF" + SEPERATOR_CHAR + "lib";
    private static final String WEB_INF_CLASSSES = "WEB-INF" + SEPERATOR_CHAR + "classes";
    private static final String META_INF_PERSISTENCE_XML = "META-INF" + SEPERATOR_CHAR + "persistence.xml";
    private static final String WEB_INF_CLASSSES_META_INF_PERSISTENCE_XML = WEB_INF_CLASSSES + SEPERATOR_CHAR + META_INF_PERSISTENCE_XML;
    private static final String JAR_SUFFIX = ".jar";

    public JPASniffer() {
        super("jpa", null, null);
    }

    public boolean handles(ReadableArchive location) {
        boolean isJPAArchive = false;
        if (this.isEntryPresent(location, WEB_INF)) {
            isJPAArchive = this.isEntryPresent(location, WEB_INF_CLASSSES_META_INF_PERSISTENCE_XML);
            if (!isJPAArchive && this.isEntryPresent(location, WEB_INF_LIB)) {
                isJPAArchive = this.scanForPURootsInLibDir(location, WEB_INF_LIB);
            }
        } else {
            isJPAArchive = this.isEntryPresent(location, META_INF_PERSISTENCE_XML);
        }
        return isJPAArchive;
    }

    protected boolean scanForPURootsInLibDir(ReadableArchive parentArchive, String libLocation) {
        boolean puRootPresent = false;
        if (libLocation != null && !libLocation.isEmpty()) {
            Enumeration entries = parentArchive.entries(libLocation);
            while (entries.hasMoreElements() && !puRootPresent) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(JAR_SUFFIX) || entryName.indexOf(SEPERATOR_CHAR, libLocation.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = parentArchive.getSubArchive(entryName);
                    puRootPresent = this.isEntryPresent(jarInLib, META_INF_PERSISTENCE_XML);
                    jarInLib.close();
                }
                catch (IOException e) {}
            }
        }
        return puRootPresent;
    }

    private boolean isEntryPresent(ReadableArchive location, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = location.exists(entry);
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }

    public String[] getContainersNames() {
        return containers;
    }

    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.toString().equals(ModuleType.WAR.toString()) || archiveType.toString().equals(ModuleType.EJB.toString()) || archiveType.toString().equals(ModuleType.CAR.toString());
    }
}

