/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.JPAJava2DBProcessor;
import org.glassfish.persistence.jpa.PersistenceUnitInfoImpl;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;

public class PersistenceUnitLoader {
    private ProviderContainerContractInfo providerContainerContractInfo;
    private EntityManagerFactory emf;
    private boolean java2db;
    private JPAJava2DBProcessor processor;
    private static Logger logger = LogDomains.getLogger(PersistenceUnitLoader.class, (String)"javax.org.glassfish.persistence");
    private static final StringManager localStrings = StringManager.getManager(PersistenceUnitLoader.class);
    private static Map<String, String> integrationPropertiesWithJava2DB;
    private static Map<String, String> integrationPropertiesWithoutJava2DB;
    private static final String ECLIPSELINK_WEAVING_PROPERTY = "eclipselink.weaving";
    private static final String VALIDATION_MODE_PROPERTY = "javax.persistence.validation.mode";
    private static final String VALIDATOR_FACTORY = "javax.persistence.validation.factory";
    private static final String DISABLE_UPGRADE_FROM_TOPLINK_ESSENTIALS = "org.glassfish.persistence.jpa.disable.upgrade.from.toplink.essentials";

    public PersistenceUnitLoader(PersistenceUnitDescriptor puToInstatntiate, ProviderContainerContractInfo providerContainerContractInfo) {
        this.providerContainerContractInfo = providerContainerContractInfo;
        this.setSystemPropertyToEnableDoPrivilegedInEclipseLink();
        this.emf = this.loadPU(puToInstatntiate);
    }

    public EntityManagerFactory getEMF() {
        return this.emf;
    }

    private void setSystemPropertyToEnableDoPrivilegedInEclipseLink() {
        String PROPERTY_NAME = "eclipselink.security.usedoprivileged";
        if (System.getProperty("eclipselink.security.usedoprivileged") == null) {
            System.setProperty("eclipselink.security.usedoprivileged", String.valueOf(Boolean.TRUE));
        }
    }

    private EntityManagerFactory loadPU(PersistenceUnitDescriptor pud) {
        PersistenceProvider provider;
        this.checkForUpgradeFromTopLinkEssentials(pud);
        this.checkForDataSourceOverride(pud);
        this.calculateDefaultDataSource(pud);
        PersistenceUnitInfoImpl pInfo = new PersistenceUnitInfoImpl(pud, this.providerContainerContractInfo);
        String applicationLocation = this.providerContainerContractInfo.getApplicationLocation();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Loading persistence unit for application: \"" + applicationLocation + "\"pu Root is: " + pud.getPuRoot());
            logger.fine("PersistenceInfo for this pud is :\n" + pInfo);
        }
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(this.providerContainerContractInfo.getClassLoader().loadClass(pInfo.getPersistenceProviderClassName()).newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (this.providerContainerContractInfo.isJava2DBRequired()) {
            this.processor = new JPAJava2DBProcessor(new Java2DBProcessorHelper(this.providerContainerContractInfo.getDeploymentContext()));
            this.java2db = this.processor.isJava2DbPU(pud);
        }
        HashMap<String, String> overRides = new HashMap<String, String>(this.java2db ? integrationPropertiesWithJava2DB : integrationPropertiesWithoutJava2DB);
        ValidationMode validationMode = this.getValidationMode(pud);
        if (validationMode == ValidationMode.AUTO || validationMode == ValidationMode.CALLBACK) {
            overRides.put(VALIDATOR_FACTORY, (String)this.providerContainerContractInfo.getValidatorFactory());
        }
        if (!this.providerContainerContractInfo.isWeavingEnabled()) {
            overRides.put(ECLIPSELINK_WEAVING_PROPERTY, System.getProperty(ECLIPSELINK_WEAVING_PROPERTY, "false"));
        }
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pInfo, overRides);
        EntityManager em = null;
        try {
            em = emf.createEntityManager();
        }
        catch (PersistenceException e) {
            emf.close();
            throw e;
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
        if (fineMsgLoggable) {
            logger.logp(Level.FINE, "PersistenceUnitLoader", "loadPU", "emf = {0}", emf);
        }
        PersistenceUnitsDescriptor parent = pud.getParent();
        RootDeploymentDescriptor containingBundle = parent.getParent();
        this.providerContainerContractInfo.registerEMF(pInfo.getPersistenceUnitName(), pud.getPuRoot(), containingBundle, emf);
        if (fineMsgLoggable) {
            logger.fine("Finished loading persistence unit for application: " + applicationLocation);
        }
        return emf;
    }

    private void checkForDataSourceOverride(PersistenceUnitDescriptor pud) {
        String jtaDataSourceOverride = this.providerContainerContractInfo.getJTADataSourceOverride();
        if (jtaDataSourceOverride != null) {
            pud.setJtaDataSource(jtaDataSourceOverride);
        }
    }

    private void calculateDefaultDataSource(PersistenceUnitDescriptor pud) {
        String jtaDataSourceName = this.calculateJtaDataSourceName(pud.getTransactionType(), pud.getJtaDataSource(), pud.getNonJtaDataSource(), pud.getName());
        String nonJtaDataSourceName = this.calculateNonJtaDataSourceName(pud.getJtaDataSource(), pud.getNonJtaDataSource());
        pud.setJtaDataSource(jtaDataSourceName);
        pud.setNonJtaDataSource(nonJtaDataSourceName);
    }

    private String calculateJtaDataSourceName(String transactionType, String userSuppliedJTADSName, String userSuppliedNonJTADSName, String puName) {
        String DSName;
        if (PersistenceUnitTransactionType.valueOf((String)transactionType) != PersistenceUnitTransactionType.JTA) {
            logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getJtaDataSource", "This PU is configured as non-jta, so jta-data-source is null");
            return null;
        }
        if (!PersistenceUnitLoader.isNullOrEmpty(userSuppliedJTADSName)) {
            DSName = userSuppliedJTADSName;
        } else if (PersistenceUnitLoader.isNullOrEmpty(userSuppliedNonJTADSName)) {
            DSName = this.providerContainerContractInfo.getDefaultDataSourceName();
        } else {
            String msg = localStrings.getString("puinfo.jta-ds-not-configured", new Object[]{puName});
            throw new RuntimeException(msg);
        }
        logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "_getJtaDataSource", "JTADSName = {0}", DSName);
        return DSName;
    }

    private String calculateNonJtaDataSourceName(String userSuppliedJTADSName, String userSuppliedNonJTADSName) {
        String DSName = !PersistenceUnitLoader.isNullOrEmpty(userSuppliedNonJTADSName) ? userSuppliedNonJTADSName : (!PersistenceUnitLoader.isNullOrEmpty(userSuppliedJTADSName) ? userSuppliedJTADSName : this.providerContainerContractInfo.getDefaultDataSourceName());
        logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getNonJtaDataSource", "nonJTADSName = {0}", DSName);
        return DSName;
    }

    static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private void checkForUpgradeFromTopLinkEssentials(PersistenceUnitDescriptor pud) {
        if (Boolean.getBoolean(DISABLE_UPGRADE_FROM_TOPLINK_ESSENTIALS)) {
            return;
        }
        boolean upgradeTopLinkEssentialsProperties = false;
        String providerClassName = pud.getProvider();
        if (providerClassName == null || providerClassName.isEmpty()) {
            upgradeTopLinkEssentialsProperties = true;
        } else if ("oracle.toplink.essentials.PersistenceProvider".equals(providerClassName) || "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider".equals(providerClassName)) {
            try {
                this.providerContainerContractInfo.getClassLoader().loadClass(providerClassName);
            }
            catch (ClassNotFoundException e) {
                String defaultProvider = PersistenceUnitInfoImpl.getDefaultprovider();
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "puloader.defaulting.provider.on.upgrade", new Object[]{pud.getName(), defaultProvider});
                }
                pud.setProvider(defaultProvider);
                upgradeTopLinkEssentialsProperties = true;
            }
        }
        if (upgradeTopLinkEssentialsProperties) {
            String TOPLINK = "toplink";
            String ECLIPSELINK = "eclipselink";
            Properties properties = pud.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("toplink")) continue;
                String translatedKey = "eclipselink" + key.substring("toplink".length());
                pud.addProperty(translatedKey, entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doJava2DB() {
        if (this.java2db) {
            boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
            EntityManager em = null;
            try {
                if (fineMsgLoggable) {
                    logger.fine("<--- To Create EM");
                }
                em = this.emf.createEntityManager();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                DeploymentContext ctx = this.providerContainerContractInfo.getDeploymentContext();
                ActionReport subActionReport = ctx.getActionReport().addSubActionsReport();
                Java2DBProcessorHelper.warnUser((ActionReport)subActionReport, (String)e.getMessage());
            }
            finally {
                if (em != null) {
                    em.close();
                }
            }
            if (fineMsgLoggable) {
                logger.fine("---> Done Create EM");
            }
            if (fineMsgLoggable) {
                logger.fine("<--- To Create Tables");
            }
            this.processor.createTablesInDB();
            if (fineMsgLoggable) {
                logger.fine("---> Done Create Tables");
            }
        }
    }

    private ValidationMode getValidationMode(PersistenceUnitDescriptor pud) {
        ValidationMode validationMode = pud.getValidationMode();
        String validationModeFromProperty = (String)pud.getProperties().get(VALIDATION_MODE_PROPERTY);
        if (validationModeFromProperty != null) {
            validationMode = ValidationMode.valueOf((String)validationModeFromProperty);
        }
        return validationMode;
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>();
        String ECLIPSELINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "eclipselink.target-server";
        props.put("eclipselink.target-server", System.getProperty("eclipselink.target-server", "SunAS9"));
        String TOPLINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "toplink.target-server";
        props.put("toplink.target-server", System.getProperty("toplink.target-server", "SunAS9"));
        String HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS_PROPERTY = "hibernate.transaction.manager_lookup_class";
        props.put("hibernate.transaction.manager_lookup_class", System.getProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.SunONETransactionManagerLookup"));
        Map baseIntegrationProperties = Collections.unmodifiableMap(props);
        HashMap<String, String> java2dbProps = new HashMap<String, String>(baseIntegrationProperties);
        String DROP_AND_CREATE = "drop-and-create-tables";
        String TOPLINK_DDL_GENERATION = "toplink.ddl-generation";
        java2dbProps.put("toplink.ddl-generation", "drop-and-create-tables");
        String ECLIPSELINK_DDL_GENERATION = "eclipselink.ddl-generation";
        java2dbProps.put("eclipselink.ddl-generation", "drop-and-create-tables");
        String DDL_SQL_SCRIPT_GENERATION = "sql-script";
        String TOPLINK_DDL_GENERATION_MODE = "toplink.ddl-generation.output-mode";
        java2dbProps.put("toplink.ddl-generation.output-mode", "sql-script");
        String ECLIPSELINK_DDL_GENERATION_MODE = "eclipselink.ddl-generation.output-mode";
        java2dbProps.put("eclipselink.ddl-generation.output-mode", "sql-script");
        integrationPropertiesWithJava2DB = Collections.unmodifiableMap(java2dbProps);
        HashMap<String, String> nonjava2dbProps = new HashMap<String, String>(baseIntegrationProperties);
        String ECLIPSELINK_DDL_GENERATION_MODE_PROPERTY = "eclipselink.ddl-generation.output-mode";
        nonjava2dbProps.put("eclipselink.ddl-generation.output-mode", System.getProperty("eclipselink.ddl-generation.output-mode", "none"));
        String TOPLINK_DDL_GENERATION_MODE_PROPERTY = "toplink.ddl-generation.output-mode";
        nonjava2dbProps.put("toplink.ddl-generation.output-mode", System.getProperty("toplink.ddl-generation.output-mode", "none"));
        integrationPropertiesWithoutJava2DB = Collections.unmodifiableMap(nonjava2dbProps);
    }
}

