/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.EmbeddedProviderContainerContractInfo;
import org.glassfish.persistence.jpa.JPAContainer;
import org.glassfish.persistence.jpa.JPApplicationContainer;
import org.glassfish.persistence.jpa.PersistenceUnitLoader;
import org.glassfish.persistence.jpa.ServerProviderContainerContractInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service
public class JPADeployer
extends SimpleDeployer<JPAContainer, JPApplicationContainer>
implements PostConstruct,
EventListener {
    private static Logger logger = LogDomains.getLogger(PersistenceUnitLoader.class, (String)"javax.org.glassfish.persistence.jpadeployer");
    private static final String EMF_KEY = EntityManagerFactory.class.toString();
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private ServerEnvironmentImpl serverEnvironment;
    @Inject
    private volatile StartupContext startupContext;
    @Inject
    private Events events;
    @Inject
    private ApplicationRegistry applicationRegistry;

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext deploymentContext) throws DeploymentException {
        OpsParams params = deploymentContext.getCommandParameters(OpsParams.class);
        if (params.origin.isUndeploy() && this.isDas()) {
            boolean hasScopedResource = false;
            String appName = params.name();
            ApplicationInfo appInfo = this.applicationRegistry.get(appName);
            Application application = (Application)appInfo.getMetaData(Application.class);
            Set bundles = application.getBundleDescriptors();
            for (BundleDescriptor bundle : bundles) {
                PersistenceUnitDescriptor pud;
                Collection pusReferencedFromBundle = bundle.findReferencedPUs();
                Iterator iterator = pusReferencedFromBundle.iterator();
                while (iterator.hasNext() && !(hasScopedResource = this.hasScopedResource(pud = (PersistenceUnitDescriptor)iterator.next()))) {
                }
            }
            if (hasScopedResource) {
                this.connectorRuntime.registerDataSourceDefinitions(application);
            }
            Java2DBProcessorHelper helper = new Java2DBProcessorHelper(deploymentContext);
            helper.init();
            helper.createOrDropTablesInDB(false, "JPA");
            if (hasScopedResource) {
                this.connectorRuntime.unRegisterDataSourceDefinitions(application);
            }
        }
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        boolean prepared = super.prepare(context);
        if (prepared && this.isEMFCreationRequired(context)) {
            this.createEMFs(context);
        }
        return prepared;
    }

    public JPApplicationContainer load(JPAContainer container, DeploymentContext context) {
        return new JPApplicationContainer();
    }

    public void event(EventListener.Event event) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JpaDeployer.event():" + event.name());
        }
        if (event.is(Deployment.APPLICATION_PREPARED)) {
            ExtendedDeploymentContext context = (ExtendedDeploymentContext)event.hook();
            DeployCommandParameters deployCommandParameters = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JpaDeployer.event(): Handling APPLICATION_PREPARED origin is:" + deployCommandParameters.origin);
            }
            if (!deployCommandParameters.origin.isCreateAppRef() || JPADeployer.isTargetDas(deployCommandParameters)) {
                Map deploymentContexts = context.getModuleDeploymentContexts();
                for (DeploymentContext deploymentContext : deploymentContexts.values()) {
                    this.iterateInitializedPUsAtApplicationPrepare(deploymentContext);
                }
                this.iterateInitializedPUsAtApplicationPrepare((DeploymentContext)context);
            }
        } else if (event.is(Deployment.APPLICATION_DISABLED)) {
            logger.fine("JpaDeployer.event(): APPLICATION_DISABLED");
            this.closeEntityManagerFactories((ApplicationInfo)event.hook());
        }
    }

    private static String getUniquePuIdentifier(PersistenceUnitDescriptor pud) {
        return pud.getAbsolutePuRoot() + pud.getName();
    }

    private static boolean isTargetDas(DeployCommandParameters deployCommandParameters) {
        return "server".equals(deployCommandParameters.target);
    }

    private boolean isDas() {
        return this.serverEnvironment.isDas() || this.serverEnvironment.isEmbedded();
    }

    private void closeEntityManagerFactories(ApplicationInfo appInfo) {
        List emfsCreatedForThisApp = (List)appInfo.getTransientAppMetaData(EMF_KEY, List.class);
        if (emfsCreatedForThisApp != null) {
            for (EntityManagerFactory entityManagerFactory : emfsCreatedForThisApp) {
                entityManagerFactory.close();
            }
            emfsCreatedForThisApp.clear();
        }
    }

    private void createEMFs(DeploymentContext context) {
        Application application = (Application)context.getModuleMetaData(Application.class);
        Set bundles = application.getBundleDescriptors();
        boolean hasScopedResource = false;
        final ArrayList<PersistenceUnitDescriptor> referencedPus = new ArrayList<PersistenceUnitDescriptor>();
        for (BundleDescriptor bundle : bundles) {
            Collection pusReferencedFromBundle = bundle.findReferencedPUs();
            for (PersistenceUnitDescriptor pud : pusReferencedFromBundle) {
                referencedPus.add(pud);
                if (!this.hasScopedResource(pud)) continue;
                hasScopedResource = true;
            }
        }
        if (hasScopedResource) {
            this.connectorRuntime.registerDataSourceDefinitions(application);
        }
        PersistenceUnitDescriptorIterator pudIterator = new PersistenceUnitDescriptorIterator(){

            @Override
            void visitPUD(PersistenceUnitDescriptor pud, DeploymentContext context) {
                if (referencedPus.contains(pud)) {
                    boolean isDas = JPADeployer.this.isDas();
                    boolean weavingEnabled = Boolean.valueOf(JPADeployer.this.startupContext.getArguments().getProperty("org.glassfish.persistence.embedded.weaving.enabled", "true"));
                    ServerProviderContainerContractInfo providerContainerContractInfo = weavingEnabled ? new ServerProviderContainerContractInfo(context, JPADeployer.this.connectorRuntime, isDas) : new EmbeddedProviderContainerContractInfo(context, JPADeployer.this.connectorRuntime, isDas);
                    try {
                        ((ExtendedDeploymentContext)context).prepareScratchDirs();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    PersistenceUnitLoader persistenceUnitLoader = new PersistenceUnitLoader(pud, providerContainerContractInfo);
                    context.addTransientAppMetaData(JPADeployer.getUniquePuIdentifier(pud), (Object)persistenceUnitLoader);
                }
            }
        };
        pudIterator.iteratePUDs(context);
    }

    private boolean hasScopedResource(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        boolean hasScopedResource = false;
        String jtaDataSource = persistenceUnitDescriptor.getJtaDataSource();
        if (jtaDataSource != null && jtaDataSource.startsWith("java:")) {
            hasScopedResource = true;
        }
        return hasScopedResource;
    }

    private boolean isEMFCreationRequired(DeploymentContext context) {
        boolean createEntityManagerFactories = false;
        DeployCommandParameters deployCommandParameters = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        boolean deploy = deployCommandParameters.origin.isDeploy();
        boolean enabled = deployCommandParameters.enabled;
        boolean isDas = this.isDas();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("isEMFCreationRequired(): deploy: " + deploy + " enabled: " + enabled + " isDas: " + isDas);
        }
        if (isDas) {
            if (deploy) {
                createEntityManagerFactories = true;
            } else {
                boolean isTargetDas = JPADeployer.isTargetDas(deployCommandParameters);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("isEMFCreationRequired(): isTargetDas: " + isTargetDas);
                }
                if (enabled && isTargetDas) {
                    createEntityManagerFactories = true;
                }
            }
        } else if (enabled) {
            createEntityManagerFactories = true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("isEMFCreationRequired(): returning createEMFs:" + createEntityManagerFactories);
        }
        return createEntityManagerFactories;
    }

    private void iterateInitializedPUsAtApplicationPrepare(DeploymentContext context) {
        final DeployCommandParameters deployCommandParameters = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        String appName = deployCommandParameters.name;
        final ApplicationInfo appInfo = this.applicationRegistry.get(appName);
        PersistenceUnitDescriptorIterator pudIterator = new PersistenceUnitDescriptorIterator(){

            @Override
            void visitPUD(PersistenceUnitDescriptor pud, DeploymentContext context) {
                PersistenceUnitLoader persistenceUnitLoader = (PersistenceUnitLoader)context.getTransientAppMetaData(JPADeployer.getUniquePuIdentifier(pud), PersistenceUnitLoader.class);
                if (persistenceUnitLoader != null) {
                    boolean saveEntityManagerFactory = true;
                    if (JPADeployer.this.isDas() && deployCommandParameters.origin.isDeploy()) {
                        EntityManagerFactory entityManagerFactory = persistenceUnitLoader.getEMF();
                        try (EntityManager entityManager = null;){
                            entityManager = entityManagerFactory.createEntityManager();
                        }
                        persistenceUnitLoader.doJava2DB();
                        boolean enabled = deployCommandParameters.enabled;
                        boolean isTargetDas = JPADeployer.isTargetDas(deployCommandParameters);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("iterateInitializedPUsAtApplicationPrepare(): enabled: " + enabled + " isTargetDas: " + isTargetDas);
                        }
                        if (!isTargetDas || !enabled) {
                            persistenceUnitLoader.getEMF().close();
                            saveEntityManagerFactory = false;
                        }
                    }
                    if (saveEntityManagerFactory) {
                        ArrayList<EntityManagerFactory> emfsCreatedForThisApp = (ArrayList<EntityManagerFactory>)appInfo.getTransientAppMetaData(EMF_KEY, List.class);
                        if (emfsCreatedForThisApp == null) {
                            emfsCreatedForThisApp = new ArrayList<EntityManagerFactory>();
                            appInfo.addTransientAppMetaData(EMF_KEY, emfsCreatedForThisApp);
                        }
                        emfsCreatedForThisApp.add(persistenceUnitLoader.getEMF());
                    }
                }
            }
        };
        pudIterator.iteratePUDs(context);
    }

    private static abstract class PersistenceUnitDescriptorIterator {
        private PersistenceUnitDescriptorIterator() {
        }

        void iteratePUDs(DeploymentContext context) {
            BundleDescriptor currentBundle = DOLUtils.getCurrentBundleForContext((DeploymentContext)context);
            if (currentBundle != null) {
                Collection pusDescriptorForThisBundle = currentBundle.getExtensionsDescriptors(PersistenceUnitsDescriptor.class);
                for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : pusDescriptorForThisBundle) {
                    for (PersistenceUnitDescriptor pud : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                        this.visitPUD(pud, context);
                    }
                }
            }
        }

        abstract void visitPUD(PersistenceUnitDescriptor var1, DeploymentContext var2);
    }
}

