/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.provider;

import com.sun.enterprise.security.jacc.provider.JACCRoleMapper;
import com.sun.enterprise.security.jacc.provider.Role;
import com.sun.enterprise.security.jacc.provider.SharedState;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanPermission;

public class SimplePolicyConfiguration
implements PolicyConfiguration {
    public static final int OPEN_STATE = 0;
    public static final int INSERVICE_STATE = 2;
    public static final int DELETED_STATE = 3;
    private static final Permission setPolicyPermission = new SecurityPermission("setPolicy");
    private String id;
    private int state = 0;
    private PermissionCollection excludedPermissions = null;
    private PermissionCollection uncheckedPermissions = null;
    private ArrayList<Role> roleTable = null;
    private ReentrantReadWriteLock pcLock = new ReentrantReadWriteLock(true);
    private Lock pcrLock = this.pcLock.readLock();
    private Lock pcwLock = this.pcLock.writeLock();

    protected SimplePolicyConfiguration(String contextID) {
        this.id = contextID;
    }

    public String getContextID() throws PolicyContextException {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            if (roleName != null && permissions != null) {
                Role role = this.getRole(roleName);
                role.addPermissions(permissions);
            }
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            if (roleName != null && permission != null) {
                Role role = this.getRole(roleName);
                role.addPermission(permission);
            }
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            if (permissions != null) {
                Enumeration<Permission> e = permissions.elements();
                while (e.hasMoreElements()) {
                    this.getUncheckedPermissions().add(e.nextElement());
                }
            }
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            if (permission != null) {
                this.getUncheckedPermissions().add(permission);
            }
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            if (permissions != null) {
                Enumeration<Permission> e = permissions.elements();
                while (e.hasMoreElements()) {
                    this.getExcludedPermissions().add(e.nextElement());
                }
            }
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            if (permission != null) {
                this.getExcludedPermissions().add(permission);
            }
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public void removeRole(String roleName) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            if (roleName != null && this.roleTable != null) {
                if (!this.roleTable.remove(new Role(roleName))) {
                    if (roleName.equals("*")) {
                        this.roleTable.clear();
                        this.roleTable = null;
                    }
                } else if (this.roleTable.isEmpty()) {
                    this.roleTable = null;
                }
            }
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            this.uncheckedPermissions = null;
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcwLock.lock();
        try {
            this.assertStateIsOpen();
            this.excludedPermissions = null;
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        this.pcrLock.lock();
        try {
            this.assertStateIsOpen();
        }
        finally {
            this.pcrLock.unlock();
        }
        SharedState.link(this.id, link.getContextID());
    }

    public void delete() throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        SharedState.removeLinks(this.id);
        this.pcwLock.lock();
        try {
            this.removePolicy();
        }
        finally {
            try {
                this.setState(3);
            }
            finally {
                this.pcwLock.unlock();
            }
        }
    }

    public void commit() throws PolicyContextException {
        SimplePolicyConfiguration.checkSetPolicyPermission();
        boolean initRoles = false;
        this.pcwLock.lock();
        try {
            if (this.stateIs(3)) {
                String msg = "pc.invalid_op_for_state_delete";
                throw new UnsupportedOperationException(msg);
            }
            if (this.stateIs(0)) {
                if (this.roleTable != null) {
                    initRoles = true;
                }
                this.setState(2);
            }
        }
        finally {
            this.pcwLock.unlock();
        }
        if (initRoles) {
            this.commitRoleMapping();
        }
    }

    public boolean inService() throws PolicyContextException {
        this.pcrLock.lock();
        try {
            boolean bl = this.stateIs(2);
            return bl;
        }
        finally {
            this.pcrLock.unlock();
        }
    }

    protected static SimplePolicyConfiguration getPolicyConfig(String pcid, boolean remove) throws PolicyContextException {
        SimplePolicyConfiguration pc = SharedState.getConfig(pcid, remove);
        pc.pcwLock.lock();
        try {
            if (remove) {
                pc.removePolicy();
            }
            pc.setState(0);
        }
        finally {
            pc.pcwLock.unlock();
        }
        return pc;
    }

    protected static boolean inService(String pcid) throws PolicyContextException {
        SimplePolicyConfiguration pc = SharedState.lookupConfig(pcid);
        if (pc == null) {
            return false;
        }
        return pc.inService();
    }

    protected static void checkSetPolicyPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPolicyPermission);
        }
    }

    private void setState(int stateValue) {
        this.state = stateValue;
    }

    private boolean stateIs(int stateValue) {
        return this.state == stateValue;
    }

    private void assertStateIsOpen() throws UnsupportedOperationException {
        if (!this.stateIs(0)) {
            String msg = "Operation invoked on closed or deleted PolicyConfiguration.";
            throw new UnsupportedOperationException(msg);
        }
    }

    private void assertStateIsInService() throws UnsupportedOperationException {
        if (!this.stateIs(2)) {
            String msg = "Operation invoked on open or deleted PolicyConfiguration.";
            throw new UnsupportedOperationException(msg);
        }
    }

    private PermissionCollection getUncheckedPermissions() {
        if (this.uncheckedPermissions == null) {
            this.uncheckedPermissions = new Permissions();
        }
        return this.uncheckedPermissions;
    }

    private PermissionCollection getExcludedPermissions() {
        if (this.excludedPermissions == null) {
            this.excludedPermissions = new Permissions();
        }
        return this.excludedPermissions;
    }

    private Role getRole(String roleName) {
        int index = -1;
        Role rvalue = new Role(roleName);
        if (this.roleTable == null) {
            this.roleTable = new ArrayList();
        } else {
            index = this.roleTable.indexOf(rvalue);
        }
        if (index < 0) {
            this.roleTable.add(rvalue);
        } else {
            rvalue = this.roleTable.get(index);
        }
        return rvalue;
    }

    private void removePolicy() {
        this.excludedPermissions = null;
        this.uncheckedPermissions = null;
        this.roleTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRoleMapping() throws PolicyContextException {
        JACCRoleMapper roleMapper = null;
        try {
            roleMapper = (JACCRoleMapper)PolicyContext.getContext((String)"simple.jacc.provider.RoleMapper");
            if (roleMapper == null) {
                throw new PolicyContextException("RoleMapper.lookup.null");
            }
        }
        catch (Throwable t) {
            SharedState.getLogger().log(Level.SEVERE, "RoleMapper.lookup.failed", t);
            if (t instanceof PolicyContextException) {
                throw (PolicyContextException)t;
            }
            throw new PolicyContextException(t);
        }
        this.pcwLock.lock();
        try {
            if (this.roleTable != null) {
                for (Role role : this.roleTable) {
                    role.setPrincipals(roleMapper.getPrincipalsInRole(this.id, role.getName()));
                }
                Role rvalue = new Role("**");
                int index = this.roleTable.indexOf(rvalue);
                if (index != -1) {
                    rvalue = this.roleTable.get(index);
                    rvalue.determineAnyAuthenticatedUserRole();
                }
            }
        }
        finally {
            this.pcwLock.unlock();
        }
    }

    public static PermissionCollection getPermissions(PermissionCollection basePerms, CodeSource codesource) throws PolicyContextException {
        SimplePolicyConfiguration pc = SharedState.getActiveConfig();
        return pc == null ? basePerms : pc.getPermissions(basePerms, null, new Principal[0]);
    }

    public static PermissionCollection getPermissions(PermissionCollection basePerms, ProtectionDomain domain) throws PolicyContextException {
        SimplePolicyConfiguration pc = SharedState.getActiveConfig();
        return pc == null ? basePerms : pc.getPermissions(basePerms, domain.getPermissions(), domain.getPrincipals());
    }

    public static int implies(ProtectionDomain domain, Permission p) throws PolicyContextException {
        SimplePolicyConfiguration pc = SharedState.getActiveConfig();
        return pc == null ? 0 : pc.doImplies(domain, p);
    }

    private boolean permIsExcluded(Permission p) {
        boolean isExcluded = false;
        if (this.hasExcludedPermissions()) {
            if (!this.getExcludedPermissions().implies(p)) {
                Enumeration<Permission> e = this.excludedPermissions.elements();
                while (e.hasMoreElements()) {
                    Permission excludedPerm = e.nextElement();
                    if (!p.implies(excludedPerm)) continue;
                    isExcluded = true;
                    break;
                }
            } else {
                isExcluded = true;
            }
        }
        return isExcluded;
    }

    private int doImplies(ProtectionDomain d, Permission p) throws PolicyContextException {
        this.pcrLock.lock();
        int rvalue = 0;
        try {
            this.assertStateIsInService();
            if (this.permIsExcluded(p)) {
                rvalue = -1;
            } else if (this.getUncheckedPermissions().implies(p)) {
                rvalue = 1;
            } else if (this.roleTable != null) {
                Principal[] principals = d.getPrincipals();
                if (principals.length == 0) {
                    rvalue = 0;
                } else {
                    for (Role role : this.roleTable) {
                        if (role.arePrincipalsInRole(principals) && role.implies(p)) {
                            rvalue = 1;
                            break;
                        }
                        if (rvalue == 1) continue;
                        rvalue = 0;
                    }
                    if (rvalue != 1) {
                        rvalue = 0;
                    }
                }
            }
            int principals = rvalue;
            return principals;
        }
        catch (UnsupportedOperationException uso) {
            throw new PolicyContextException((Throwable)uso);
        }
        finally {
            this.pcrLock.unlock();
        }
    }

    private boolean hasExcludedPermissions() {
        return this.excludedPermissions != null && this.excludedPermissions.elements().hasMoreElements();
    }

    private PermissionCollection getPermissions(PermissionCollection basePerms, PermissionCollection domainPerms, Principal[] principals) throws PolicyContextException, UnsupportedOperationException {
        this.pcrLock.lock();
        try {
            Object object;
            Permission p;
            Enumeration<Permission> e;
            this.assertStateIsInService();
            Permissions c = null;
            boolean hasExcludes = this.hasExcludedPermissions();
            if (basePerms != null) {
                e = basePerms.elements();
                while (e.hasMoreElements()) {
                    p = e.nextElement();
                    if (hasExcludes && this.permIsExcluded(p)) continue;
                    if (c == null) {
                        c = new Permissions();
                    }
                    c.add(p);
                }
            }
            if (domainPerms != null) {
                e = domainPerms.elements();
                while (e.hasMoreElements()) {
                    p = e.nextElement();
                    if (hasExcludes && this.permIsExcluded(p)) continue;
                    if (c == null) {
                        c = new Permissions();
                    }
                    c.add(p);
                }
            }
            e = this.getUncheckedPermissions().elements();
            while (e.hasMoreElements()) {
                p = e.nextElement();
                if (hasExcludes && this.permIsExcluded(p)) continue;
                if (c == null) {
                    c = new Permissions();
                }
                c.add(p);
            }
            if (principals.length == 0 || this.roleTable == null) {
                object = c;
                return object;
            }
            for (Role role : this.roleTable) {
                if (!role.arePrincipalsInRole(principals)) continue;
                Permissions rc = role.getPermissions();
                Enumeration<Permission> e2 = ((PermissionCollection)rc).elements();
                while (e2.hasMoreElements()) {
                    Permission p2 = e2.nextElement();
                    if (hasExcludes && this.permIsExcluded(p2)) continue;
                    if (c == null) {
                        c = new Permissions();
                    }
                    c.add(p2);
                }
            }
            object = c;
            return object;
        }
        catch (UnsupportedOperationException uso) {
            throw new PolicyContextException((Throwable)uso);
        }
        finally {
            this.pcrLock.unlock();
        }
    }

    static void refresh() throws PolicyContextException {
    }

    static void doPrivilegedLog(final Level level, final String msg, final Object[] params) {
        final Logger logger = SharedState.getLogger();
        if (logger.isLoggable(level)) {
            if (System.getSecurityManager() == null) {
                logger.log(level, msg, params);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        logger.log(level, msg, params);
                        return null;
                    }
                });
            }
        }
    }

    static void doPrivilegedLog(final Level level, final String msg, final Throwable t) {
        final Logger logger = SharedState.getLogger();
        if (logger.isLoggable(level)) {
            if (System.getSecurityManager() == null) {
                logger.log(level, msg, t);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        logger.log(level, msg, t);
                        return null;
                    }
                });
            }
        }
    }

    static void logGetPermissionsFailure(Object o, Throwable t) {
        String id = PolicyContext.getContextID();
        SimplePolicyConfiguration.doPrivilegedLog(Level.INFO, "getPermissions.failure", new Object[]{id, o});
        SimplePolicyConfiguration.doPrivilegedLog(Level.INFO, "getPermissions.failure", t);
    }

    private static boolean permissionShouldBeLogged(Permission p) {
        return !(p instanceof WebResourcePermission) && !(p instanceof WebUserDataPermission) && !(p instanceof MBeanPermission) && !(p instanceof WebRoleRefPermission) && !(p instanceof EJBRoleRefPermission);
    }

    static void logAccessFailure(ProtectionDomain d, Permission p) {
        if (SimplePolicyConfiguration.permissionShouldBeLogged(p) || SharedState.getLogger().isLoggable(Level.FINE)) {
            String id = PolicyContext.getContextID();
            SimplePolicyConfiguration.doPrivilegedLog(Level.FINE, "Domain.that.failed", new Object[]{id, p, d});
        }
    }

    static void logException(Level l, String msg, Throwable t) {
        String id = PolicyContext.getContextID();
        SimplePolicyConfiguration.doPrivilegedLog(l, msg, new Object[]{id});
        SimplePolicyConfiguration.doPrivilegedLog(l, msg, t);
    }

    static {
        try {
            String className = System.getProperty("simple.jacc.provider.JACCRoleMapper.class");
            if (className != null || !PolicyContext.getHandlerKeys().contains("simple.jacc.provider.RoleMapper")) {
                if (className == null) {
                    String packageName = SimplePolicyConfiguration.class.getPackage().getName();
                    className = packageName + ".GlassfishRoleMapper";
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass(className);
                final Constructor<?> ctx = clazz.getConstructor(Logger.class);
                PolicyContext.registerHandler((String)"simple.jacc.provider.RoleMapper", (PolicyContextHandler)new PolicyContextHandler(){

                    public Object getContext(String key, Object data) throws PolicyContextException {
                        if (key.equals("simple.jacc.provider.RoleMapper")) {
                            try {
                                return ctx.newInstance(SharedState.getLogger());
                            }
                            catch (Throwable t) {
                                throw new PolicyContextException(t);
                            }
                        }
                        return null;
                    }

                    public String[] getKeys() throws PolicyContextException {
                        return new String[]{"simple.jacc.provider.RoleMapper"};
                    }

                    public boolean supports(String key) throws PolicyContextException {
                        return key.equals("simple.jacc.provider.RoleMapper");
                    }
                }, (boolean)false);
            }
        }
        catch (Throwable t) {
            SharedState.getLogger().log(Level.SEVERE, "RoleMapper.registration.failed", t);
            throw new RuntimeException(t);
        }
    }
}

