/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.provider;

import com.sun.enterprise.security.jacc.provider.SimplePolicyConfiguration;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.logging.Level;

public class SimplePolicyProvider
extends Policy {
    private static final String REUSE = "java.security.Policy.supportsReuse";
    private Policy basePolicy = Policy.getPolicy();
    private static ThreadLocal<Object> reentrancyStatus = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return new byte[]{0};
        }
    };

    public SimplePolicyProvider() {
        if (this.basePolicy == null) {
            try {
                this.basePolicy = Policy.getInstance("JavaPolicy", null);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(codesource);
        try {
            permissionCollection = SimplePolicyConfiguration.getPermissions(permissionCollection, codesource);
        }
        catch (PolicyContextException pce) {
            SimplePolicyConfiguration.logGetPermissionsFailure(codesource, pce);
        }
        return permissionCollection;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(domain);
        try {
            permissionCollection = SimplePolicyConfiguration.getPermissions(permissionCollection, domain);
        }
        catch (PolicyContextException pce) {
            SimplePolicyConfiguration.logGetPermissionsFailure(domain, pce);
        }
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        byte[] alreadyCalled = (byte[])reentrancyStatus.get();
        if (alreadyCalled[0] == 1) {
            return true;
        }
        alreadyCalled[0] = 1;
        try {
            boolean bl = this.doImplies(domain, permission);
            return bl;
        }
        finally {
            alreadyCalled[0] = 0;
        }
    }

    private boolean doImplies(ProtectionDomain domain, Permission permission) {
        int result;
        block5: {
            result = -1;
            try {
                result = SimplePolicyConfiguration.implies(domain, permission);
                if (result > 0) {
                    return true;
                }
            }
            catch (PolicyContextException pce) {
                if (result == 0) break block5;
                result = 1;
            }
        }
        boolean rvalue = false;
        if (result == 0) {
            rvalue = this.basePolicy.implies(domain, permission);
        }
        if (!rvalue) {
            SimplePolicyConfiguration.logAccessFailure(domain, permission);
        }
        return rvalue;
    }

    @Override
    public void refresh() {
        this.basePolicy.refresh();
        try {
            boolean supportsReuse;
            String propValue = System.getProperty(REUSE);
            boolean bl = supportsReuse = propValue == null ? true : Boolean.valueOf(propValue);
            if (supportsReuse && PolicyContext.getHandlerKeys().contains(REUSE)) {
                PolicyContext.getContext((String)REUSE);
            }
            SimplePolicyConfiguration.refresh();
        }
        catch (PolicyContextException pce) {
            SimplePolicyConfiguration.logException(Level.SEVERE, "refresh.failure", pce);
            throw new IllegalStateException(pce);
        }
    }
}

