/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl;

import com.sun.enterprise.security.store.PasswordAdapter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.SecretKey;
import org.glassfish.api.admin.PasswordAliasStore;

public class JCEKSPasswordAliasStore
implements PasswordAliasStore {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private PasswordAdapter pa = null;
    private String pathToAliasStore;
    private char[] storePassword;

    protected final void init(String pathToAliasStore, char[] storePassword) {
        this.pathToAliasStore = pathToAliasStore;
        this.storePassword = storePassword;
    }

    private synchronized PasswordAdapter pa() {
        if (this.pa == null) {
            try {
                this.pa = new PasswordAdapter(this.pathToAliasStore, this.storePassword);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.pa;
    }

    public static JCEKSPasswordAliasStore newInstance(String pathToAliasStore, char[] storePassword) {
        JCEKSPasswordAliasStore result = new JCEKSPasswordAliasStore();
        result.init(pathToAliasStore, storePassword);
        return result;
    }

    public void clear() {
        try {
            Enumeration aliasEnum = this.pa().getAliases();
            while (aliasEnum.hasMoreElements()) {
                this.pa().removeAlias((String)aliasEnum.nextElement());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void put(String alias, char[] password) {
        CharBuffer charBuffer = CharBuffer.wrap(password);
        ByteBuffer byteBuffer = utf8.encode(charBuffer);
        try {
            this.pa().setPasswordForAlias(alias, byteBuffer.array());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void putAll(PasswordAliasStore otherStore) {
        HashMap<String, char[]> entries = new HashMap<String, char[]>();
        Iterator aliasIt = otherStore.keys();
        while (aliasIt.hasNext()) {
            String alias = (String)aliasIt.next();
            entries.put(alias, otherStore.get(alias));
        }
        this.putAll(entries);
    }

    public void putAll(Map<String, char[]> settings) {
        for (Map.Entry<String, char[]> entry : settings.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        settings.clear();
    }

    public void remove(String alias) {
        try {
            this.pa().removeAlias(alias);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean containsKey(String alias) {
        try {
            return this.pa().aliasExists(alias);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public char[] get(String alias) {
        try {
            SecretKey secretKey = this.pa().getPasswordSecretKeyForAlias(alias);
            ByteBuffer byteBuffer = ByteBuffer.wrap(secretKey.getEncoded());
            return utf8.decode(byteBuffer).array();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator<String> keys() {
        ArrayList keys = new ArrayList();
        try {
            Enumeration aliases = this.pa().getAliases();
            while (aliases.hasMoreElements()) {
                keys.add(aliases.nextElement());
            }
            return keys.iterator();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public int size() {
        try {
            int size = 0;
            Enumeration aliases = this.pa().getAliases();
            while (aliases.hasMoreElements()) {
                ++size;
                aliases.nextElement();
            }
            return size;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

