/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.provider.authorization;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminPrincipal;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.security.services.api.authorization.AuthorizationAdminConstants;
import org.glassfish.security.services.api.authorization.AuthorizationService;
import org.glassfish.security.services.api.authorization.AzAction;
import org.glassfish.security.services.api.authorization.AzAttributeResolver;
import org.glassfish.security.services.api.authorization.AzEnvironment;
import org.glassfish.security.services.api.authorization.AzResource;
import org.glassfish.security.services.api.authorization.AzResult;
import org.glassfish.security.services.api.authorization.AzSubject;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.impl.authorization.AzObligationsImpl;
import org.glassfish.security.services.impl.authorization.AzResultImpl;
import org.glassfish.security.services.provider.authorization.AuthorizationProviderConfig;
import org.glassfish.security.services.spi.AuthorizationProvider;
import org.jvnet.hk2.annotations.Service;

@Service(name="simpleAuthorization")
@PerLookup
public class SimpleAuthorizationProviderImpl
implements AuthorizationProvider {
    private static final Level DEBUG_LEVEL = Level.FINER;
    private AuthorizationProviderConfig cfg;
    private boolean deployable;
    private String version;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ServiceLocator serviceLocator;
    private Domain domain = null;
    private SecureAdmin secureAdmin = null;
    protected static final Logger _logger = LogDomains.getLogger(SimpleAuthorizationProviderImpl.class, (String)"javax.enterprise.system.core.security");
    private Decider decider;

    @Override
    public void initialize(SecurityProvider providerConfig) {
        this.cfg = (AuthorizationProviderConfig)providerConfig.getSecurityProviderConfig().get(0);
        this.deployable = this.cfg.getSupportPolicyDeploy();
        this.version = this.cfg.getVersion();
        this.domain = (Domain)this.serviceLocator.getService(Domain.class, new Annotation[0]);
        this.secureAdmin = this.domain.getSecureAdmin();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "provide to do policy deploy: " + this.deployable);
            _logger.log(Level.FINE, "provide version to use: " + this.version);
        }
    }

    protected Decider createDecider() {
        return new Decider();
    }

    private synchronized Decider getDecider() {
        if (this.decider == null) {
            this.decider = this.createDecider();
            if (this.isDebug()) {
                _logger.log(DEBUG_LEVEL, "Created SimpleAuthorizationProviderImpl Decider of type {0}", this.decider.getClass().getName());
            }
        }
        return this.decider;
    }

    private boolean isDebug() {
        return _logger.isLoggable(DEBUG_LEVEL);
    }

    @Override
    public AzResult getAuthorizationDecision(AzSubject subject, AzResource resource, AzAction action, AzEnvironment environment, List<AzAttributeResolver> attributeResolvers) {
        if (!this.isAdminResource(resource)) {
            String resourceName = resource.getUri() == null ? "null" : resource.getUri().toASCIIString();
            _logger.log(Level.WARNING, resourceName, new IllegalArgumentException(resourceName));
        }
        return this.getAdminDecision(subject, resource, action, environment);
    }

    private boolean isAdminResource(AzResource resource) {
        URI resourceURI = resource.getUri();
        return "admin".equals(resourceURI.getScheme());
    }

    private AzResult getAdminDecision(AzSubject subject, AzResource resource, AzAction action, AzEnvironment environment) {
        if (this.isDebug()) {
            _logger.log(DEBUG_LEVEL, "");
        }
        AzResultImpl rtn = new AzResultImpl(this.getDecider().decide(subject, resource, action, environment), AzResult.Status.OK, new AzObligationsImpl());
        return rtn;
    }

    @Override
    public AuthorizationService.PolicyDeploymentContext findOrCreateDeploymentContext(String appContext) {
        return null;
    }

    protected class Decider {
        protected Decider() {
        }

        protected AzResult.Decision decide(AzSubject subject, AzResource resource, AzAction action, AzEnvironment env) {
            AzResult.Decision result = this.isSubjectTrustedForDASAndInstances(subject) || this.isSubjectAnAdministrator(subject) && (SimpleAuthorizationProviderImpl.this.serverEnv.isDas() || this.isActionRead(action)) ? AzResult.Decision.PERMIT : AzResult.Decision.DENY;
            return result;
        }

        protected String getAdminGroupName() {
            return "asadmin";
        }

        private boolean isSubjectTrustedForDASAndInstances(AzSubject subject) {
            HashSet<String> principalNames = new HashSet<String>();
            for (Principal p : subject.getSubject().getPrincipals()) {
                principalNames.add(p.getName());
            }
            principalNames.retainAll(AuthorizationAdminConstants.TRUSTED_FOR_DAS_OR_INSTANCE);
            return !principalNames.isEmpty();
        }

        private boolean isActionRead(AzAction action) {
            return "read".equals(action.getAction());
        }

        private boolean isSubjectAnAdministrator(AzSubject subject) {
            return this.isPrincipalType(subject, this.getAdminGroupName()) || this.hasSecureAdminPrincipal(subject);
        }

        private boolean isPrincipalType(AzSubject subject, String type) {
            for (Principal p : subject.getSubject().getPrincipals()) {
                if (!type.equals(p.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean hasSecureAdminPrincipal(AzSubject subject) {
            if (SimpleAuthorizationProviderImpl.this.secureAdmin == null) {
                return false;
            }
            for (Principal p : subject.getSubject().getPrincipals()) {
                for (SecureAdminPrincipal sap : SimpleAuthorizationProviderImpl.this.secureAdmin.getSecureAdminPrincipal()) {
                    if (!sap.getDn().equals(p.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

