/*
 * Copyright (c) 2012, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.security.services.config;

import java.beans.PropertyVetoException;

import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;

/**
 * Base interface for all security provider implementation configuration.
 *
 * Security plugin configuration objects extend SecurityProviderConfig interface
 * such that the configuration of the plugin can be associated with a specific
 * security service configuration.
 */
@Configured
public interface SecurityProviderConfig extends ConfigBeanProxy {
    /**
     * Gets the name of the security provider implementation.
     */
    @Attribute(required=true, key=true)
    public String getName();
    public void setName(String value) throws PropertyVetoException;
}
