/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.common.AppservAccessController;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.services.api.authentication.ImpersonationService;
import org.glassfish.security.services.common.Secure;
import org.glassfish.security.services.config.AuthenticationService;
import org.glassfish.security.services.config.LoginModuleConfig;
import org.glassfish.security.services.config.SecurityConfiguration;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.config.SecurityProviderConfig;
import org.glassfish.security.services.impl.AuthenticationServiceFactory;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@Secure(accessPermissionName="security/service/authentication")
public class AuthenticationServiceImpl
implements org.glassfish.security.services.api.authentication.AuthenticationService,
PostConstruct {
    @Inject
    private Domain domain;
    @Inject
    ServerContext serverContext;
    @Inject
    private ServiceLocator locator;
    @Inject
    private ImpersonationService impersonationService;
    private String name = null;
    private String realmName = null;
    private Configuration configuration = null;
    private boolean usePasswordCredential = false;
    private AuthenticationService config = null;

    @Override
    public void initialize(SecurityConfiguration securityServiceConfiguration) {
        this.config = (AuthenticationService)securityServiceConfiguration;
        if (this.config == null) {
            return;
        }
        this.name = this.config.getName();
        this.usePasswordCredential = this.config.getUsePasswordCredential();
        List<SecurityProvider> providers = this.config.getSecurityProviders();
        if (providers != null) {
            ArrayList<AppConfigurationEntry> lmEntries = new ArrayList<AppConfigurationEntry>();
            for (SecurityProvider provider : providers) {
                String authRealm;
                List<SecurityProviderConfig> providerConfig;
                if (!"LoginModule".equalsIgnoreCase(provider.getType()) || (providerConfig = provider.getSecurityProviderConfig()) == null || providerConfig.isEmpty()) continue;
                LoginModuleConfig lmConfig = (LoginModuleConfig)providerConfig.get(0);
                Map<String, ?> lmOptions = lmConfig.getModuleOptions();
                lmEntries.add(new AppConfigurationEntry(lmConfig.getModuleClass(), this.getLoginModuleControlFlag(lmConfig.getControlFlag()), lmOptions));
                if (!this.usePasswordCredential || this.realmName != null || (authRealm = (String)lmOptions.get("auth-realm")) == null || authRealm.isEmpty()) continue;
                this.realmName = authRealm;
            }
            if (!lmEntries.isEmpty()) {
                this.configuration = new AuthenticationJaasConfiguration(this.name, lmEntries);
            }
        }
        if (this.usePasswordCredential && this.realmName != null) {
            RealmsManager realmsManager = (RealmsManager)this.locator.getService(RealmsManager.class, new Annotation[0]);
            realmsManager.createRealms();
        }
    }

    @Override
    public Subject login(String username, char[] password, Subject subject) throws LoginException {
        AuthenticationCallbackHandler cbh = new AuthenticationCallbackHandler(username, password);
        return this.loginEx(cbh, subject);
    }

    @Override
    public Subject login(CallbackHandler cbh, Subject subject) throws LoginException {
        if (cbh == null) {
            throw new LoginException("AuthenticationService: JAAS CallbackHandler not supplied");
        }
        return this.loginEx(cbh, subject);
    }

    private Subject loginEx(CallbackHandler handler, Subject subject) throws LoginException {
        Subject _subject;
        block10: {
            ClassLoader cl;
            _subject = subject;
            if (_subject == null) {
                _subject = new Subject();
            }
            ClassLoader tcl = null;
            boolean restoreTcl = false;
            try {
                if (this.configuration == null) {
                    throw new UnsupportedOperationException("JAAS Configuration setup incomplete, unable to perform login");
                }
                if (this.usePasswordCredential) {
                    this.setupPasswordCredential(_subject, handler);
                }
                tcl = (ClassLoader)AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<ClassLoader>(this){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                final ClassLoader ccl = this.serverContext.getCommonClassLoader();
                if (!ccl.equals(tcl)) {
                    AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(this){

                        @Override
                        public Object run() {
                            Thread.currentThread().setContextClassLoader(ccl);
                            return null;
                        }
                    });
                    restoreTcl = true;
                }
                LoginContext context = new LoginContext(this.name, _subject, handler, this.configuration);
                context.login();
                if (!restoreTcl) break block10;
                cl = tcl;
            }
            catch (Exception exc) {
                try {
                    if (exc instanceof LoginException) {
                        throw (LoginException)exc;
                    }
                    throw (LoginException)new LoginException("AuthenticationService: " + exc.getMessage()).initCause(exc);
                }
                catch (Throwable throwable) {
                    if (restoreTcl) {
                        ClassLoader cl2 = tcl;
                        AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(this, cl2){
                            final /* synthetic */ ClassLoader val$cl;
                            {
                                this.val$cl = classLoader;
                            }

                            @Override
                            public Object run() {
                                Thread.currentThread().setContextClassLoader(this.val$cl);
                                return null;
                            }
                        });
                    }
                    throw throwable;
                }
            }
            AppservAccessController.doPrivileged((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
        }
        return _subject;
    }

    @Override
    public Subject impersonate(String user, String[] groups, Subject subject, boolean virtual) throws LoginException {
        return this.impersonationService.impersonate(user, groups, subject, virtual);
    }

    public void postConstruct() {
        if (Globals.getDefaultBaseServiceLocator() == null) {
            Globals.setDefaultHabitat((ServiceLocator)this.locator);
        }
        this.initialize(AuthenticationServiceFactory.getAuthenticationServiceConfiguration(this.domain));
    }

    private void setupPasswordCredential(Subject subject, CallbackHandler callbackHandler) throws LoginException {
        String username = null;
        char[] password = null;
        if (callbackHandler instanceof AuthenticationCallbackHandler) {
            username = ((AuthenticationCallbackHandler)callbackHandler).getUsername();
            password = ((AuthenticationCallbackHandler)callbackHandler).getPassword();
        } else {
            Callback[] callbacks = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false)};
            try {
                callbackHandler.handle(callbacks);
                username = ((NameCallback)callbacks[0]).getName();
                password = ((PasswordCallback)callbacks[1]).getPassword();
            }
            catch (IOException ioe) {
                throw (LoginException)new LoginException("AuthenticationService unable to create PasswordCredential: " + ioe.getMessage()).initCause(ioe);
            }
            catch (UnsupportedCallbackException uce) {
                throw (LoginException)new LoginException("AuthenticationService unable to create PasswordCredential: " + uce.getMessage()).initCause(uce);
            }
        }
        final Subject s = subject;
        final PasswordCredential pc = new PasswordCredential(username, password, this.realmName);
        AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(this){

            @Override
            public Object run() {
                s.getPrivateCredentials().add(pc);
                return null;
            }
        });
    }

    private AppConfigurationEntry.LoginModuleControlFlag getLoginModuleControlFlag(String controlFlag) {
        AppConfigurationEntry.LoginModuleControlFlag flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        if (controlFlag != null) {
            if ("required".equalsIgnoreCase(controlFlag)) {
                return flag;
            }
            if ("sufficient".equalsIgnoreCase(controlFlag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if ("optional".equalsIgnoreCase(controlFlag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else if ("requisite".equalsIgnoreCase(controlFlag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
        }
        return flag;
    }

    private static class AuthenticationJaasConfiguration
    extends Configuration {
        private final String configurationName;
        private final AppConfigurationEntry[] lmEntries;

        private AuthenticationJaasConfiguration(String name, ArrayList<AppConfigurationEntry> entries) {
            this.configurationName = name;
            this.lmEntries = entries.toArray(new AppConfigurationEntry[entries.size()]);
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            if (this.configurationName.equals(name)) {
                return this.lmEntries;
            }
            return null;
        }
    }

    private static class AuthenticationCallbackHandler
    implements CallbackHandler {
        private final String user;
        private final char[] pass;

        public AuthenticationCallbackHandler(String username, char[] password) {
            this.user = username;
            this.pass = password;
        }

        protected String getUsername() {
            return this.user;
        }

        protected char[] getPassword() {
            return this.pass;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.user);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.pass);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "AuthenticationCallbackHandler: Unrecognized Callback " + callback.getClass().getName());
            }
        }
    }
}

