/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils.mock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.Principal;
import javax.security.auth.Subject;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.security.common.PrincipalImpl;

public class MockGenerator {
    private static final InvocationHandler MOCK_HANDLER = (proxy, method, args) -> {
        throw new UnsupportedOperationException("Feature-free dummy implementation for injection only");
    };

    public Subject createAsadminSubject() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new PrincipalImpl("asadmin"));
        subject.getPrincipals().add((Principal)new PrincipalImpl("_InternalSystemAdministrator_"));
        return subject;
    }

    public <T> AbstractActiveDescriptor<T> createMockDescriptor(Class<T> iface) {
        T mock = this.createMockThrowingExceptions(iface);
        AbstractActiveDescriptor descriptor = BuilderHelper.createConstantDescriptor(mock, null, (Type[])new Type[]{iface});
        descriptor.setRanking(Integer.MAX_VALUE);
        descriptor.setReified(true);
        return descriptor;
    }

    public <T> T createMockThrowingExceptions(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, MOCK_HANDLER);
    }
}

