/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils.junit;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.server.ServerEnvironmentImpl;
import org.glassfish.tests.utils.junit.Classes;
import org.glassfish.tests.utils.junit.DomainXml;
import org.glassfish.tests.utils.junit.ExcludeClasses;
import org.glassfish.tests.utils.junit.HK2ClasssVisitor;
import org.glassfish.tests.utils.junit.LocatorFiles;
import org.glassfish.tests.utils.junit.Packages;
import org.glassfish.tests.utils.mock.MockGenerator;
import org.glassfish.tests.utils.mock.TestDocument;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.Transactions;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class HK2JUnit5Extension
implements BeforeAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final Logger LOG = Logger.getLogger(HK2JUnit5Extension.class.getName());
    private static final String CLASS_PATH_PROP = "java.class.path";
    private static final String DOT_CLASS = ".class";
    private static final String START_TIME_METHOD = "start time method";
    private MockGenerator mockGenerator;
    private ServiceLocator locator;
    private DynamicConfiguration config;
    private StartupContext startupContext;
    private StaticModulesRegistry modulesRegistry;
    private ExtensionContext.Namespace namespaceMethod;

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        ClassLoader loader = this.getClassLoader(context);
        this.mockGenerator = new MockGenerator();
        Properties startupContextProperties = this.getStartupContextProperties(context);
        LOG.log(Level.CONFIG, "startupContextProperties set to {0}", startupContextProperties);
        this.startupContext = new StartupContext(startupContextProperties);
        this.modulesRegistry = new StaticModulesRegistry(this.getClassLoader(context), this.startupContext);
        this.locator = this.createLocator(context);
        this.addConstantServices(context);
        String domainXml = this.getDomainXml(testClass);
        Class<DomDocument<?>> domainXmlDomClass = this.getDomainXmlDomClass(testClass);
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, domainXmlDomClass.getConstructor(ServiceLocator.class).newInstance(this.locator));
        if (domainXml != null) {
            this.addConfigFromResource(loader, domainXml, domainXmlDomClass);
        }
        List<String> packages = this.getPackages(testClass);
        List<Class<?>> classes = this.getClasses(testClass);
        Set<Class<?>> excludedClasses = this.getExcludedClasses(testClass);
        this.config = ((DynamicConfigurationService)this.locator.getService(DynamicConfigurationService.class, new Annotation[0])).createDynamicConfiguration();
        this.addServicesFromLocatorFiles(loader, excludedClasses, this.getLocatorFilePaths(context));
        this.addServicesFromPackage(packages, excludedClasses);
        this.addServices(classes, excludedClasses);
        try {
            this.config.commit();
        }
        catch (Exception e) {
            ServiceLocatorUtilities.dumpAllDescriptors((ServiceLocator)this.locator, (PrintStream)System.err);
            throw e;
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        LOG.log(Level.FINE, "Injecting attributes to the test instance: {0}", testInstance);
        this.locator.inject(testInstance);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        LOG.log(Level.FINE, "beforeEach. Test name: {0}", context.getRequiredTestMethod());
        this.namespaceMethod = ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass(), context.getRequiredTestMethod()});
        context.getStore(this.namespaceMethod).put((Object)START_TIME_METHOD, (Object)LocalDateTime.now());
    }

    public void afterEach(ExtensionContext context) throws Exception {
        LocalDateTime startTime = (LocalDateTime)context.getStore(this.namespaceMethod).remove((Object)START_TIME_METHOD, LocalDateTime.class);
        LOG.log(Level.INFO, "Test: {0}.{1}, started at {2}, test time: {3} ms", new Object[]{context.getRequiredTestClass().getName(), context.getRequiredTestMethod().getName(), DateTimeFormatter.ISO_LOCAL_TIME.format(startTime), startTime.until(LocalDateTime.now(), ChronoUnit.MILLIS)});
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.modulesRegistry != null) {
            this.modulesRegistry.shutdown();
        }
        if (this.locator != null) {
            this.locator.shutdown();
        }
    }

    protected ServiceLocator getLocator() {
        return this.locator;
    }

    protected String getLocatorName(ExtensionContext context) {
        return context.getRequiredTestClass().getSimpleName() + "ServiceLocator";
    }

    protected ServiceLocator createLocator(ExtensionContext context) {
        ServiceLocator newLocator = ServiceLocatorUtilities.createAndPopulateServiceLocator((String)this.getLocatorName(context));
        Assertions.assertNotNull((Object)newLocator.getService(Transactions.class, new Annotation[0]), (String)"Transactions service from Configuration subsystem is not available!");
        return newLocator;
    }

    protected ClassLoader getClassLoader(ExtensionContext context) {
        return context.getRequiredTestClass().getClassLoader();
    }

    protected Properties getStartupContextProperties(ExtensionContext context) {
        Properties startupContextProperties = new Properties();
        String rootPath = context.getRequiredTestClass().getResource("/").getPath();
        startupContextProperties.put("com.sun.aas.installRoot", rootPath);
        startupContextProperties.put("com.sun.aas.instanceRoot", rootPath);
        return startupContextProperties;
    }

    protected void addConstantServices(ExtensionContext context) {
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)Logger.getLogger(context.getRequiredTestClass().getName()), (String)"testLogger", (Type[])new Type[]{Logger.class});
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)this.mockGenerator);
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)this.startupContext);
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)this.modulesRegistry);
        String installRoot = this.startupContext.getArguments().getProperty("com.sun.aas.installRoot");
        if (installRoot == null) {
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)new ServerEnvironmentImpl());
        } else {
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)new ServerEnvironmentImpl(new File(installRoot)));
        }
    }

    protected String getDomainXml(Class<?> testClass) {
        DomainXml domainXmlAnnotation = testClass.getAnnotation(DomainXml.class);
        return domainXmlAnnotation == null ? null : domainXmlAnnotation.value();
    }

    protected Class<? extends DomDocument<?>> getDomainXmlDomClass(Class<?> testClass) {
        DomainXml domainXmlAnnotation = testClass.getAnnotation(DomainXml.class);
        return domainXmlAnnotation == null ? TestDocument.class : domainXmlAnnotation.domDocumentClass();
    }

    protected List<String> getPackages(Class<?> testClass) {
        Packages packagesAnnotation = testClass.getAnnotation(Packages.class);
        List<String> packages = packagesAnnotation == null ? List.of(testClass.getPackageName()) : Arrays.asList(packagesAnnotation.value());
        return packages;
    }

    protected List<Class<?>> getClasses(Class<?> testClass) {
        Classes classesAnnotation = testClass.getAnnotation(Classes.class);
        List<Class<?>> classes = classesAnnotation == null ? List.of() : List.of(classesAnnotation.value());
        return classes;
    }

    protected Set<Class<?>> getExcludedClasses(Class<?> testClass) {
        ExcludeClasses excludeClassesAnnotation = testClass.getAnnotation(ExcludeClasses.class);
        Set<Class<?>> excludedClasses = excludeClassesAnnotation == null ? Set.of() : Set.of(excludeClassesAnnotation.value());
        return excludedClasses;
    }

    protected Set<String> getLocatorFilePaths(ExtensionContext context) {
        HashSet<String> paths = new HashSet<String>();
        LocatorFiles locatorFilePaths = context.getRequiredTestClass().getAnnotation(LocatorFiles.class);
        if (locatorFilePaths == null) {
            paths.add("META-INF/hk2-locator/default");
            return paths;
        }
        for (String path : locatorFilePaths.value()) {
            paths.add(path);
        }
        return paths;
    }

    protected void addMockDescriptor(Class<?> iface) {
        ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.locator, this.mockGenerator.createMockDescriptor(iface));
    }

    private void addConfigFromResource(ClassLoader loader, String resourcePath, Class<? extends DomDocument<?>> domClass) {
        URL url = Objects.requireNonNull(loader.getResource(resourcePath), "The resourcePath doesn't exist: " + resourcePath);
        DomDocument testDocumentService = Objects.requireNonNull((DomDocument)this.locator.getService(domClass, new Annotation[0]), "service " + domClass);
        ConfigParser configParser = new ConfigParser(this.locator);
        DomDocument document = configParser.parse(url, testDocumentService);
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)document, null, (Type[])new Type[]{DomDocument.class, domClass});
    }

    private void addServicesFromLocatorFiles(ClassLoader loader, Set<Class<?>> excludedClasses, Set<String> locatorFiles) {
        for (String locatorFile : locatorFiles) {
            Enumeration<URL> resources;
            try {
                resources = loader.getResources(locatorFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Resource could not be loaded: " + locatorFile, e);
            }
            this.readResources(resources, excludedClasses);
        }
    }

    private void addServicesFromPackage(List<String> packages, Set<Class<?>> excludedClasses) {
        if (packages.isEmpty()) {
            return;
        }
        String classPath = System.getProperty(CLASS_PATH_PROP);
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            this.addServicesFromPathElement(packages, st.nextToken(), excludedClasses);
        }
    }

    private void addServices(List<Class<?>> classes, Set<Class<?>> excludedClasses) {
        for (Class<?> clazz : classes) {
            if (excludedClasses.contains(clazz)) continue;
            this.config.addActiveDescriptor(clazz);
        }
    }

    private void addServicesFromPathElement(List<String> packages, String path, Set<Class<?>> excludedClasses) {
        File fileElement = new File(path);
        if (!fileElement.exists()) {
            return;
        }
        if (fileElement.isDirectory()) {
            this.addServicesFromPathDirectory(packages, fileElement, excludedClasses);
        } else {
            this.addServicesFromPathJar(packages, fileElement, excludedClasses);
        }
    }

    private void addServicesFromPathDirectory(List<String> packages, File directory, Set<Class<?>> excludedClasses) {
        for (String pack : packages) {
            File[] candidates;
            File searchDir = new File(directory, HK2JUnit5Extension.convertToFileFormat(pack));
            if (!searchDir.exists() || !searchDir.isDirectory() || (candidates = searchDir.listFiles((dir, name) -> {
                if (name == null) {
                    return false;
                }
                return name.endsWith(DOT_CLASS);
            })) == null) continue;
            for (File candidate : candidates) {
                try (FileInputStream fis = new FileInputStream(candidate);){
                    this.addClassIfService(fis, excludedClasses);
                }
                catch (IOException e) {
                    throw new IllegalStateException("addServicesFromPathDirectory failed.", e);
                }
            }
        }
    }

    private void addServicesFromPathJar(List<String> packages, File jar, Set<Class<?>> excludedClasses) {
        try (JarFile jarFile = new JarFile(jar);){
            for (String pack : packages) {
                String packAsFile = HK2JUnit5Extension.convertToFileFormat(pack);
                int packAsFileLen = packAsFile.length() + 1;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(packAsFile) || entryName.substring(packAsFileLen).contains("/") || !entryName.endsWith(DOT_CLASS)) continue;
                    try {
                        this.addClassIfService(jarFile.getInputStream(entry), excludedClasses);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("addServicesFromPathJar failed.", e);
        }
    }

    private void readResources(Enumeration<URL> resources, Set<Class<?>> excludedClasses) {
        Set exclude = excludedClasses.stream().map(Class::getName).collect(Collectors.toSet());
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                DescriptorImpl descriptor;
                boolean goOn;
                while (goOn = (descriptor = new DescriptorImpl()).readObject(reader)) {
                    if (exclude.contains(descriptor.getImplementation())) continue;
                    this.config.bind((Descriptor)descriptor);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("readResources failed.", e);
            }
        }
    }

    private static String convertToFileFormat(String clazzFormat) {
        return clazzFormat.replaceAll("\\.", "/");
    }

    private void addClassIfService(InputStream is, Set<Class<?>> excludedClasses) throws IOException {
        ClassReader reader = new ClassReader(is);
        HK2ClasssVisitor cvi = new HK2ClasssVisitor(this.locator, excludedClasses);
        reader.accept((ClassVisitor)cvi, 7);
    }
}

