/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils.junit.matcher;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public class WaitForExecutable
implements Executable {
    private static final System.Logger LOG = System.getLogger(WaitForExecutable.class.getName());
    private final Executable executable;

    private WaitForExecutable(Executable executable) {
        this.executable = executable;
    }

    public static void waitFor(Executable executable, long timeoutInMillis) throws Throwable {
        WaitForExecutable.waitUntilPassed(executable, timeoutInMillis).execute();
    }

    public static WaitForExecutable waitUntilPassed(Executable executable, long timeoutInMillis) {
        Executable newExecutable = () -> {
            long currentTimeMillis = System.currentTimeMillis();
            long limit = currentTimeMillis + timeoutInMillis;
            while (true) {
                try {
                    executable.execute();
                    return;
                }
                catch (AssertionError e) {
                    long now = System.currentTimeMillis();
                    if (now > limit) {
                        throw e;
                    }
                    LOG.log(System.Logger.Level.WARNING, "Nope. Remaining time is {0} ms. Waiting ...", limit - now);
                    Thread.sleep(100L);
                    continue;
                }
                catch (Throwable e) {
                    Assertions.fail((Throwable)e);
                    continue;
                }
                break;
            }
        };
        return new WaitForExecutable(newExecutable);
    }

    public void execute() throws Throwable {
        this.executable.execute();
    }
}

