/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils.junit;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;

class HK2ClasssVisitor
extends ClassVisitor {
    private static final Logger LOG = Logger.getLogger(HK2ClasssVisitor.class.getName());
    private static final String SERVICE_CLASS_FORM = "Lorg/jvnet/hk2/annotations/Service;";
    private final ServiceLocator locator;
    private final Set<String> excludedClasses;
    private String implName;
    private boolean isAService;

    public HK2ClasssVisitor(ServiceLocator locator, Set<Class<?>> excludedClasses) {
        super(589824);
        this.locator = locator;
        this.excludedClasses = excludedClasses.stream().map(Class::getName).collect(Collectors.toSet());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.implName = name.replace("/", ".");
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return null;
        }
        if (SERVICE_CLASS_FORM.equals(desc)) {
            this.isAService = true;
        }
        return null;
    }

    public void visitEnd() {
        if (!this.isAService) {
            return;
        }
        if (this.excludedClasses.contains(this.implName)) {
            return;
        }
        Class<?> implClass = null;
        try {
            implClass = Class.forName(this.implName, true, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.WARNING, "Classloading failed for service {0}, skipped. Reason: {1}", new Object[]{this.implName, e});
            return;
        }
        List added = ServiceLocatorUtilities.addClasses((ServiceLocator)this.locator, (Class[])new Class[]{implClass});
        LOG.log(Level.CONFIG, "Added HK2 services: {0}", added);
    }
}

