/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import org.glassfish.virtualization.libvirt.LibVirtException;
import org.glassfish.virtualization.libvirt.jna.LibVirtLibrary;
import org.glassfish.virtualization.libvirt.jna.VirError;
import org.glassfish.virtualization.spi.VirtException;

public class LibVirtError {
    ErrorNumber code;
    ErrorDomain domain;
    String message;
    ErrorLevel level;
    String str1;
    String str2;
    String str3;
    int int1;
    int int2;

    public LibVirtError(VirError vError) {
        this.code = ErrorNumber.values()[vError.code];
        this.domain = ErrorDomain.values()[vError.domain];
        this.level = ErrorLevel.values()[vError.level];
        this.message = vError.message;
        this.str1 = vError.str1;
        this.str2 = vError.str2;
        this.str3 = vError.str3;
        this.int1 = vError.int1;
        this.int2 = vError.int2;
    }

    public ErrorLevel getLevel() {
        return this.level;
    }

    public static void processError(LibVirtLibrary libvirt) throws VirtException {
        VirError vError = new VirError();
        int errorCode = libvirt.virCopyLastError(vError);
        if (errorCode > 0) {
            LibVirtError error = new LibVirtError(vError);
            libvirt.virResetLastError();
            if (error.getLevel() == ErrorLevel.VIR_ERR_ERROR) {
                throw new LibVirtException(error);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorNumber {
        VIR_ERR_OK,
        VIR_ERR_INTERNAL_ERROR,
        VIR_ERR_NO_MEMORY,
        VIR_ERR_NO_SUPPORT,
        VIR_ERR_UNKNOWN_HOST,
        VIR_ERR_NO_CONNECT,
        VIR_ERR_INVALID_CONN,
        VIR_ERR_INVALID_DOMAIN,
        VIR_ERR_INVALID_ARG,
        VIR_ERR_OPERATION_FAILED,
        VIR_ERR_GET_FAILED,
        VIR_ERR_POST_FAILED,
        VIR_ERR_HTTP_ERROR,
        VIR_ERR_SEXPR_SERIAL,
        VIR_ERR_NO_XEN,
        VIR_ERR_XEN_CALL,
        VIR_ERR_OS_TYPE,
        VIR_ERR_NO_KERNEL,
        VIR_ERR_NO_ROOT,
        VIR_ERR_NO_SOURCE,
        VIR_ERR_NO_TARGET,
        VIR_ERR_NO_NAME,
        VIR_ERR_NO_OS,
        VIR_ERR_NO_DEVICE,
        VIR_ERR_NO_XENSTORE,
        VIR_ERR_DRIVER_FULL,
        VIR_ERR_CALL_FAILED,
        VIR_ERR_XML_ERROR,
        VIR_ERR_DOM_EXIST,
        VIR_ERR_OPERATION_DENIED,
        VIR_ERR_OPEN_FAILED,
        VIR_ERR_READ_FAILED,
        VIR_ERR_PARSE_FAILED,
        VIR_ERR_CONF_SYNTAX,
        VIR_ERR_WRITE_FAILED,
        VIR_ERR_XML_DETAIL,
        VIR_ERR_INVALID_NETWORK,
        VIR_ERR_NETWORK_EXIST,
        VIR_ERR_SYSTEM_ERROR,
        VIR_ERR_RPC,
        VIR_ERR_GNUTLS_ERROR,
        VIR_WAR_NO_NETWORK,
        VIR_ERR_NO_DOMAIN,
        VIR_ERR_NO_NETWORK,
        VIR_ERR_INVALID_MAC,
        VIR_ERR_AUTH_FAILED,
        VIR_ERR_INVALID_STORAGE_POOL,
        VIR_ERR_INVALID_STORAGE_VOL,
        VIR_WAR_NO_STORAGE,
        VIR_ERR_NO_STORAGE_POOL,
        VIR_ERR_NO_STORAGE_VOL,
        VIR_WAR_NO_NODE,
        VIR_ERR_INVALID_NODE_DEVICE,
        VIR_ERR_NO_NODE_DEVICE,
        VIR_ERR_NO_SECURITY_MODEL,
        VIR_ERR_OPERATION_INVALID,
        VIR_WAR_NO_INTERFACE,
        VIR_ERR_NO_INTERFACE,
        VIR_ERR_INVALID_INTERFACE,
        VIR_ERR_MULTIPLE_INTERFACES,
        VIR_WAR_NO_SECRET,
        VIR_ERR_INVALID_SECRET,
        VIR_ERR_NO_SECRET;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorLevel {
        VIR_ERR_NONE,
        VIR_ERR_WARNING,
        VIR_ERR_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorDomain {
        VIR_FROM_NONE,
        VIR_FROM_XEN,
        VIR_FROM_XEND,
        VIR_FROM_XENSTORE,
        VIR_FROM_SEXPR,
        VIR_FROM_XML,
        VIR_FROM_DOM,
        VIR_FROM_RPC,
        VIR_FROM_PROXY,
        VIR_FROM_CONF,
        VIR_FROM_QEMU,
        VIR_FROM_NET,
        VIR_FROM_TEST,
        VIR_FROM_REMOTE,
        VIR_FROM_OPENVZ,
        VIR_FROM_XENXM,
        VIR_FROM_STATS_LINUX,
        VIR_FROM_LXC,
        VIR_FROM_STORAGE,
        VIR_FROM_NETWORK,
        VIR_FROM_DOMAIN,
        VIR_FROM_UML,
        VIR_FROM_NODEDEV,
        VIR_FROM_XEN_INOTIFY,
        VIR_FROM_SECURITY,
        VIR_FROM_VBOX,
        VIR_FROM_INTERFACE,
        VIR_FROM_ONE,
        VIR_FROM_ESX,
        VIR_FROM_PHYP,
        VIR_FROM_SECRET;

    }
}

