/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import com.sun.enterprise.config.serverbeans.Cluster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.ServerPoolConfig;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.VirtualMachineConfig;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.libvirt.CDRomDisk;
import org.glassfish.virtualization.libvirt.LibVirtServerPool;
import org.glassfish.virtualization.libvirt.LibVirtStoragePool;
import org.glassfish.virtualization.libvirt.LibVirtStorageVol;
import org.glassfish.virtualization.libvirt.LibVirtVirtualMachine;
import org.glassfish.virtualization.libvirt.config.LibvirtVirtualization;
import org.glassfish.virtualization.libvirt.jna.Connect;
import org.glassfish.virtualization.libvirt.jna.Domain;
import org.glassfish.virtualization.runtime.AbstractMachine;
import org.glassfish.virtualization.runtime.VirtualMachineLifecycle;
import org.glassfish.virtualization.spi.AllocationPhase;
import org.glassfish.virtualization.spi.EventSource;
import org.glassfish.virtualization.spi.FileOperations;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.MachineOperations;
import org.glassfish.virtualization.spi.OsInterface;
import org.glassfish.virtualization.spi.PhasedFuture;
import org.glassfish.virtualization.spi.PhysicalServerPool;
import org.glassfish.virtualization.spi.StoragePool;
import org.glassfish.virtualization.spi.StorageVol;
import org.glassfish.virtualization.spi.TemplateInstance;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.ListenableFutureImpl;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.PostConstruct;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibVirtLocalMachine
extends AbstractMachine
implements PostConstruct {
    final Map<String, LibVirtVirtualMachine> domains = new HashMap<String, LibVirtVirtualMachine>();
    final Map<String, LibVirtStoragePool> storagePools = new HashMap<String, LibVirtStoragePool>();
    Connect connect;
    @Inject
    Virtualizations virtualizations;
    @Inject
    Services services;
    @Inject
    VirtualMachineLifecycle vmLifecycle;
    @Inject
    com.sun.enterprise.config.serverbeans.Domain domainConfig;
    @Inject
    ClassLoaderHierarchy clh;

    public static LibVirtLocalMachine from(Injector injector, LibVirtServerPool group, MachineConfig config) {
        return (LibVirtLocalMachine)((Object)injector.inject((Object)new LibVirtLocalMachine(group, config)));
    }

    protected LibVirtLocalMachine(LibVirtServerPool group, MachineConfig config) {
        super((PhysicalServerPool)group, config);
    }

    public void postConstruct() {
        this.setState(this.isUp() ? Machine.State.READY : Machine.State.SUSPENDED);
        super.postConstruct();
    }

    public LibVirtStoragePool addStoragePool(String name, long capacity) throws VirtException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<pool type='dir'>\n").append("  <name>").append(name).append("</name>\n").append("  <uuid>").append(UUID.randomUUID()).append("</uuid>\n").append("  <capacity>").append(capacity).append("</capacity>\n").append("  <source>\n").append("  </source>\n").append("  <target>\n").append("    <path>").append(this.getUserHome()).append("/").append(this.config.getDisksLocation()).append("</path>\n").append("    <permissions>\n").append("      <mode>0700</mode>\n").append("      <owner>").append(this.getUser().getUserId()).append("</owner>\n").append("      <group>").append(this.getUser().getGroupId()).append("</group>\n").append("      <serverPool>").append(this.getServerPool().getName()).append("</serverPool>\n").append("    </permissions>\n").append("  </target>\n").append("</pool>");
            LibVirtStoragePool storagePool = new LibVirtStoragePool((Machine)this, this.connection().storagePoolCreateXML(sb.toString(), 0));
            this.storagePools.put(name, storagePool);
            return storagePool;
        }
        catch (VirtException e) {
            throw new VirtException((Throwable)e);
        }
    }

    public String description() {
        StringBuffer sb = new StringBuffer();
        sb.append("Machine ").append(this.getName());
        try {
            this.connection();
            int[] domainIds = this.connect.listDomains();
            if (domainIds == null || domainIds.length == 0) {
                sb.append(" with no virtual machines defined");
            } else {
                sb.append(" with domains : [");
                for (int domainId : domainIds) {
                    Domain testDomain = this.connect.domainLookupByID(domainId);
                    sb.append("[ domain:").append(testDomain.getName()).append(" id ").append(testDomain.getID()).append(" running ").append(testDomain.getOSType()).append(" ]");
                }
                sb.append("]");
            }
        }
        catch (Exception e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception caught :" + e, e);
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public Collection<? extends VirtualMachine> getVMs() throws VirtException {
        try {
            this.populate();
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of domains ", e);
        }
        return this.domains.values();
    }

    public Map<String, ? extends StoragePool> getStoragePools() throws VirtException {
        try {
            this.populate();
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of storage pools ", e);
        }
        return Collections.unmodifiableMap(this.storagePools);
    }

    public VirtualMachine byName(String name) throws VirtException {
        if (!this.domains.containsKey(name)) {
            try {
                this.populate();
            }
            catch (VirtException e) {
                RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of domains ", e);
            }
        }
        return (VirtualMachine)this.domains.get(name);
    }

    public void sleep() throws IOException, InterruptedException {
        throw new IOException("Impossible to put myself to sleep");
    }

    private LibvirtVirtualization getVirtualizationConfig() {
        return (LibvirtVirtualization)this.getServerPool().getConfig().getVirtualization();
    }

    protected Connect connection() throws VirtException {
        if (this.connect == null && this.getUser() != null && this.getUser().getName() != null) {
            try {
                String connectionString = this.getVirtualizationConfig().getConnectionString();
                if (this.getUser().getAuthMethod().length() > 0) {
                    connectionString = connectionString.replace("#{auth.sep}", "+");
                    connectionString = connectionString.replace("#{auth.method}", this.getUser().getAuthMethod());
                } else {
                    connectionString = connectionString.replace("#{auth.sep}", "");
                    connectionString = connectionString.replace("#{auth.method}", "");
                }
                connectionString = connectionString.replace("#{user.name}", this.getUser().getName());
                connectionString = connectionString.replace("#{target.host}", this.getIpAddress());
                System.out.println("Connecting to " + connectionString);
                this.connect = new Connect(connectionString);
            }
            catch (VirtException e) {
                System.out.println("exception caught:" + (Object)((Object)e));
                throw e;
            }
        }
        return this.connect;
    }

    private void populate() throws VirtException {
        if (this.getIpAddress() == null) {
            RuntimeContext.logger.log(Level.INFO, "Cannot find IP address for " + this.getName());
            return;
        }
        try {
            Connect connection = this.connection();
            if (connection != null) {
                this.populateStoragePools(this.connection().listStoragePools());
                ArrayList<StorageVol> storageVols = new ArrayList<StorageVol>();
                for (LibVirtStoragePool pool : this.storagePools.values()) {
                    for (StorageVol vol : pool.volumes()) {
                        storageVols.add(vol);
                    }
                }
                for (int domainId : this.connection().listDomains()) {
                    try {
                        this.populateDomain(domainId, storageVols);
                    }
                    catch (VirtException e) {
                        for (int d : this.connection().listDomains()) {
                            if (d != domainId) continue;
                            throw e;
                        }
                    }
                }
                for (String domainId : this.connection().listDefinedDomains()) {
                    try {
                        this.populateDomain(domainId, storageVols);
                    }
                    catch (VirtException e) {
                        for (String d : this.connection().listDefinedDomains()) {
                            if (!d.equals(domainId)) continue;
                            throw e;
                        }
                    }
                }
            }
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of domains ", e);
            throw e;
        }
    }

    private void populateStoragePools(String[] poolsNames) throws VirtException {
        for (String poolName : poolsNames) {
            this.populateStoragePool(poolName);
        }
    }

    private void populateStoragePool(String name) throws VirtException {
        LibVirtStoragePool gfPool = new LibVirtStoragePool((Machine)this, this.connection().storagePoolLookupByName(name));
        this.storagePools.put(name, gfPool);
    }

    private void populateDomain(int domainId, Collection<StorageVol> volumes) throws VirtException {
        this.addDomain(this.connection().domainLookupByID(domainId), volumes);
    }

    private void populateDomain(String domainId, Collection<StorageVol> volumes) throws VirtException {
        this.addDomain(this.connect.domainLookupByName(domainId), volumes);
    }

    private void addDomain(Domain domain, Collection<StorageVol> volumes) throws VirtException {
        String domainName = domain.getName();
        if (!this.domains.containsKey(domainName)) {
            for (Cluster cluster : this.domainConfig.getClusters().getCluster()) {
                for (VirtualMachineConfig vmc : cluster.getExtensionsByType(VirtualMachineConfig.class)) {
                    if (!vmc.getName().equals(domainName)) continue;
                    ArrayList<StorageVol> storageVols = new ArrayList<StorageVol>();
                    for (StorageVol storageVol : volumes) {
                        if (!storageVol.getName().startsWith(domainName)) continue;
                        storageVols.add(storageVol);
                    }
                    LibVirtVirtualMachine gfVM = new LibVirtVirtualMachine(vmc, vmc.getTemplate().getUser(), (Machine)this, domain, storageVols);
                    this.domains.put(domainName, gfVM);
                    return;
                }
            }
        }
    }

    public PhasedFuture<AllocationPhase, VirtualMachine> create(TemplateInstance template, VirtualCluster cluster, EventSource<AllocationPhase> source) throws VirtException, IOException {
        this.populate();
        source.fireEvent((Enum)AllocationPhase.VM_PREPARE);
        String name = cluster.getConfig().getName() + cluster.allocateToken();
        File xml = template.getFileByExtension("xml");
        Element xmlConfig = this.loadConfigFile(xml);
        List volumes = this.prepare(template, name, cluster);
        File machineDisks = this.absolutize(new File(this.virtualizations.getDisksLocation(), this.serverPool.getName()));
        machineDisks = new File(machineDisks, this.getName());
        File custDirectory = this.prepareCustDirectory(name, cluster.getConfig(), template.getConfig());
        final File custFile = new File(machineDisks, name + "cust.iso");
        this.prepareCustomization(custDirectory, custFile, name);
        final String diskLocation = this.config.getDisksLocation();
        this.execute((MachineOperations)new MachineOperations<Object>(){

            public Object run(FileOperations fileOperations) throws IOException {
                int maxTries = 5;
                while (maxTries > 0) {
                    try {
                        RuntimeContext.logger.log(Level.INFO, "Transfer of customization disk started");
                        fileOperations.copy(custFile, new File(diskLocation));
                        RuntimeContext.logger.log(Level.INFO, "Transfer of customization disk finished");
                        return null;
                    }
                    catch (IOException e) {
                        RuntimeContext.logger.log(Level.SEVERE, "Cannot copy customization disk to target machine", e);
                        if (--maxTries == 0) {
                            throw e;
                        }
                        String remotePath = new File(diskLocation, custFile.getName()).getPath();
                        RuntimeContext.logger.info("Deleting invalid copy at " + remotePath);
                        try {
                            fileOperations.delete(remotePath);
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        RuntimeContext.logger.log(Level.INFO, "Retrying copy...");
                    }
                }
                throw new IOException("Dead code, file a bug");
            }
        });
        OsInterface os = (OsInterface)this.services.forContract(OsInterface.class).get();
        String uuid = UUID.randomUUID().toString();
        String macAddress = os.macAddressGen();
        xmlConfig.setAttribute("type", this.getVirtualizationConfig().getName());
        NodeList children = xmlConfig.getChildNodes();
        for (int k = 0; k < children.getLength(); ++k) {
            Node node = children.item(k);
            if (node.getNodeName().equals("name")) {
                node.getChildNodes().item(0).setNodeValue(name);
            }
            if (node.getNodeName().equals("uuid")) {
                node.getChildNodes().item(0).setNodeValue(uuid);
            }
            if (!node.getNodeName().equals("devices")) continue;
            NodeList devices = node.getChildNodes();
            for (int i = 0; i < devices.getLength(); ++i) {
                Node device = devices.item(i);
                if (device.getNodeName().equals("disk")) {
                    node.removeChild(device);
                }
                if (device.getNodeName().equals("interface") && device.getAttributes().getNamedItem("type").getNodeValue().equals("bridge")) {
                    NodeList intfInfos = device.getChildNodes();
                    for (int j = 0; j < intfInfos.getLength(); ++j) {
                        if (!intfInfos.item(j).getNodeName().equals("mac")) continue;
                        intfInfos.item(j).getAttributes().getNamedItem("address").setNodeValue(macAddress);
                    }
                }
                if (!device.getNodeName().equals("emulator")) continue;
                device.getChildNodes().item(0).setNodeValue(this.getVirtualizationConfig().getEmulatorPath());
            }
            int position = 0;
            for (StorageVol aVol : volumes) {
                if (!(aVol instanceof LibVirtStorageVol)) continue;
                Node newNode = ((LibVirtStorageVol)aVol).getXML(node, position++);
                node.appendChild(newNode);
            }
            CDRomDisk cdRom = new CDRomDisk();
            Node cdRomNode = cdRom.save(this.getUserHome() + "/" + this.config.getDisksLocation() + "/" + custFile.getName(), node, 0);
            node.appendChild(cdRomNode);
        }
        File destXml = new File(System.getProperty("java.io.tmpdir"), name + ".xml");
        this.writeConfig(xmlConfig, destXml);
        RuntimeContext.logger.info("XML definition file for VM at " + destXml.getAbsolutePath());
        System.out.println("I would use " + uuid + " id with mac " + macAddress);
        LibVirtVirtualMachine vm = null;
        try {
            Domain domain = this.connection().domainDefineXML(this.getConfig(xmlConfig));
            source.fireEvent((Enum)AllocationPhase.VM_SPAWN);
            CountDownLatch latch = this.vmLifecycle.inStartup(name);
            VirtualMachineConfig vmConfig = VirtualMachineConfig.Utils.create((String)domain.getName(), (Template)template.getConfig(), (ServerPoolConfig)this.serverPool.getConfig(), (Cluster)cluster.getConfig());
            vm = new LibVirtVirtualMachine(vmConfig, template.getConfig().getUser(), (Machine)this, domain, volumes);
            this.domains.put(name, vm);
            cluster.add((VirtualMachine)vm);
            ListenableFutureImpl future = new ListenableFutureImpl(latch, (Object)vm, source);
            future.fireEvent((Enum)AllocationPhase.VM_START);
            vm.start();
            return future;
        }
        catch (VirtException e) {
            try {
                RuntimeContext.logger.log(Level.SEVERE, "Exception while allocating the virtual machine", e);
                if (vm != null) {
                    vm.delete();
                }
                for (StorageVol volume : volumes) {
                    volume.delete();
                }
            }
            catch (VirtException e1) {
                RuntimeContext.logger.log(Level.SEVERE, "Exception while cleaning failed virtual machine creation", e1);
            }
            throw new VirtException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element loadConfigFile(File xml) {
        ClassLoader tcc = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.clh.getCommonClassLoader());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder loader = factory.newDocumentBuilder();
            Document document = loader.parse(xml);
            Element element = document.getDocumentElement();
            return element;
        }
        catch (IOException ex) {
            this.handleError(ex);
        }
        catch (SAXException ex) {
            this.handleError(ex);
        }
        catch (ParserConfigurationException ex) {
            this.handleError(ex);
        }
        catch (FactoryConfigurationError ex) {
            this.handleError(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcc);
        }
        return null;
    }

    private void writeConfig(Node doc, File destination) {
        try {
            this.write(doc, new StreamResult(destination));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getConfig(Node doc) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(doc, new StreamResult(baos));
            return baos.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void write(Node doc, Result result) throws TransformerException {
        ClassLoader tcc = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.clh.getCommonClassLoader());
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(new DOMSource(doc), result);
        Thread.currentThread().setContextClassLoader(tcc);
    }

    private void handleError(Throwable e) {
        e.printStackTrace();
    }
}

