/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.libvirt.LibVirtLocalMachine;
import org.glassfish.virtualization.libvirt.LibVirtServerPool;
import org.glassfish.virtualization.libvirt.SSHFileOperations;
import org.glassfish.virtualization.spi.FileOperations;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.MachineOperations;
import org.glassfish.virtualization.spi.PhysicalServerPool;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LibVirtMachine
extends LibVirtLocalMachine {
    final String ipAddress;
    @Inject
    SSHLauncher sshLauncher;
    SSHFileOperations sshFileOperations;
    int references = 0;

    public static LibVirtMachine from(Injector injector, LibVirtServerPool group, MachineConfig config, String ipAddress) {
        return (LibVirtMachine)((Object)injector.inject((Object)new LibVirtMachine(group, config, ipAddress)));
    }

    protected LibVirtMachine(LibVirtServerPool group, MachineConfig config, String ipAddress) {
        super(group, config);
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(MachineOperations<T> operations) throws IOException {
        SSHFileOperations sshFileOperations;
        try {
            sshFileOperations = this.connect();
        }
        catch (IOException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Cannot open connection to machine " + (Object)((Object)this), e);
            throw e;
        }
        try {
            Object object = operations.run((FileOperations)sshFileOperations);
            return (T)object;
        }
        finally {
            this.disconnect();
        }
    }

    public PhysicalServerPool getServerPool() {
        return this.serverPool;
    }

    public void ping() throws IOException, InterruptedException {
        SSHLauncher ssl = this.getSSH();
        ssl.pingConnection();
    }

    @Override
    public void sleep() throws IOException, InterruptedException {
        SSHLauncher ssl = this.getSSH();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ssl.runCommand("sudo pm-suspend", (OutputStream)baos);
        System.out.println(baos.toString());
    }

    public boolean isUp() {
        if (Machine.State.READY.equals((Object)this.getState())) {
            return true;
        }
        if (this.ipAddress == null) {
            return false;
        }
        try {
            this.ping();
        }
        catch (Exception e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while pinging " + this.config.getName() + " : " + e.getMessage());
            RuntimeContext.logger.log(Level.FINE, "Exception while pinging " + this.config.getName(), e);
            return false;
        }
        try {
            this.connection();
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Cannot connect to machine " + this.config.getName() + " with the user " + this.serverPool.getConfig().getUser().getName(), e);
            return false;
        }
        return true;
    }

    public VirtUser getUser() {
        if (this.config.getUser() != null) {
            return this.config.getUser();
        }
        return this.serverPool.getConfig().getUser();
    }

    protected String getUserHome() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.getSSH().runCommand("echo $HOME", (OutputStream)baos);
        }
        catch (Exception e) {
            return "/home" + this.getUser().getName();
        }
        String userHome = baos.toString();
        return userHome.substring(0, userHome.length() - 1);
    }

    private synchronized SSHFileOperations connect() throws IOException {
        if (this.sshFileOperations == null) {
            this.sshFileOperations = new SSHFileOperations((Machine)this, this.sshLauncher);
        }
        ++this.references;
        return this.sshFileOperations;
    }

    private synchronized void disconnect() throws IOException {
        --this.references;
        if (this.references == 0) {
            this.sshFileOperations.close();
            this.sshFileOperations = null;
        }
    }

    private SSHLauncher getSSH() {
        File home = new File(System.getProperty("user.home"));
        String keyFile = new File(home, ".ssh/id_dsa").getAbsolutePath();
        this.sshLauncher.init(this.getUser().getName(), this.ipAddress, 22, null, keyFile, null, Logger.getAnonymousLogger());
        return this.sshLauncher;
    }
}

