/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.ServerPoolConfig;
import org.glassfish.virtualization.libvirt.LibVirtLocalMachine;
import org.glassfish.virtualization.libvirt.LibVirtMachine;
import org.glassfish.virtualization.spi.AllocationPhase;
import org.glassfish.virtualization.spi.EventSource;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.OsInterface;
import org.glassfish.virtualization.spi.PhasedFuture;
import org.glassfish.virtualization.spi.PhysicalServerPool;
import org.glassfish.virtualization.spi.TemplateInstance;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibVirtServerPool
implements PhysicalServerPool,
ConfigListener {
    final ConcurrentMap<String, Machine> machines = new ConcurrentHashMap<String, Machine>();
    final AtomicInteger allocationCount = new AtomicInteger();
    final Injector injector;
    final ServerPoolConfig config;

    public LibVirtServerPool(Injector injector, ServerPoolConfig config) {
        this.injector = injector;
        this.config = config;
        Dom.unwrap((ConfigBeanProxy)config).addListener((ConfigListener)this);
        this.populateGroup();
    }

    public ServerPoolConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.config.getName();
    }

    public Collection<VirtualMachine> getVMs() throws VirtException {
        ArrayList<VirtualMachine> vms = new ArrayList<VirtualMachine>();
        for (Machine machine : this.machines.values()) {
            vms.addAll(machine.getVMs());
        }
        return vms;
    }

    public Iterable<? extends Machine> machines() {
        return this.machines.values();
    }

    public int size() {
        return this.machines.size();
    }

    public VirtualMachine vmByName(String name) throws VirtException {
        for (Machine machine : this.machines.values()) {
            VirtualMachine vm = machine.byName(name);
            if (vm == null) continue;
            return vm;
        }
        return null;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])propertyChangeEvents, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (t instanceof MachineConfig) {
                    MachineConfig machineConfig = (MachineConfig)MachineConfig.class.cast(t);
                    if (type.equals((Object)Changed.TYPE.ADD)) {
                        if (machineConfig.getIpAddress() == null) {
                            Map macToIps = LibVirtServerPool.this.macAddressesToIps();
                            LibVirtServerPool.this.addMachine(machineConfig, (String)macToIps.get(machineConfig.getMacAddress()));
                        } else {
                            LibVirtServerPool.this.addMachine(machineConfig, machineConfig.getIpAddress());
                        }
                    }
                }
                return null;
            }
        }, (Logger)Logger.getAnonymousLogger());
    }

    public Machine byName(String machineName) {
        return (Machine)this.machines.get(machineName);
    }

    private Map<String, String> macAddressesToIps() {
        OsInterface os = (OsInterface)this.getHabitat().getComponent(OsInterface.class);
        return os.populateMacToIpsTable((PhysicalServerPool)this);
    }

    private void populateGroup() {
        Properties cached = new Properties();
        File cache = null;
        try {
            cache = new File(RuntimeContext.getCacheDir(), this.config.getName() + ".cache");
            if (cache.exists()) {
                this.populateCachedValues(cached, cache);
            }
        }
        catch (IOException e) {
            RuntimeContext.logger.log(Level.INFO, "Error while reading cache, recalculating all machines IPs", e);
        }
        Map<String, String> macToIps = null;
        boolean dirtyCache = false;
        for (MachineConfig machineConfig : this.config.getMachines()) {
            String ipAddress;
            if (cached.containsKey(machineConfig.getName())) {
                LibVirtMachine machine;
                ipAddress = cached.getProperty(machineConfig.getName());
                LibVirtLocalMachine libVirtLocalMachine = machine = machineConfig.getNetworkName() != null && machineConfig.getNetworkName().equals("localhost") ? LibVirtLocalMachine.from(this.injector, this, machineConfig) : LibVirtMachine.from(this.injector, this, machineConfig, ipAddress);
                if (machine.isUp()) {
                    this.addMachine((Machine)machine);
                    continue;
                }
            }
            if ((ipAddress = machineConfig.getIpAddress()) == null) {
                String macAddress = machineConfig.getMacAddress();
                if (macAddress != null && macToIps == null) {
                    macToIps = this.macAddressesToIps();
                }
                if (macToIps != null) {
                    ipAddress = macToIps.get(macAddress);
                }
            }
            this.addMachine(machineConfig, ipAddress);
            if (ipAddress == null) continue;
            cached.put(machineConfig.getName(), ipAddress);
            dirtyCache = true;
        }
        if (dirtyCache && cache != null) {
            try {
                this.saveCachedValues(cached, cache);
            }
            catch (IOException e) {
                RuntimeContext.logger.log(Level.INFO, "Error while writing cache", e);
            }
        }
        for (Machine machine : this.machines()) {
            try {
                for (VirtualMachine vm : machine.getVMs()) {
                    this.allocationCount.incrementAndGet();
                }
            }
            catch (VirtException e) {
                RuntimeContext.logger.log(Level.SEVERE, "Cannot obtain list of virtual machines", e);
            }
        }
        Dom.unwrap((ConfigBeanProxy)this.config).addListener(new ConfigListener(){

            public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
                return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])propertyChangeEvents, (Changed)new Changed(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                        if (t instanceof MachineConfig) {
                            MachineConfig machineConfig = (MachineConfig)MachineConfig.class.cast(t);
                            if (type.equals((Object)Changed.TYPE.ADD)) {
                                LibVirtServerPool.this.addMachine(machineConfig, machineConfig.getIpAddress());
                            }
                            if (type.equals((Object)Changed.TYPE.REMOVE)) {
                                1 var5_5 = this;
                                synchronized (var5_5) {
                                    LibVirtServerPool.this.machines.remove(machineConfig.getName());
                                }
                            }
                        }
                        return null;
                    }
                }, (Logger)RuntimeContext.logger);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCachedValues(Properties cached, File cache) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(cache);
            cached.load(reader);
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCachedValues(Properties cached, File cache) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(cache);
            cached.store(writer, "Cache file for serverPool " + this.config.getName());
        }
        finally {
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
    }

    private void addMachine(MachineConfig machineConfig, String ipAddress) {
        LibVirtMachine machine = machineConfig.getNetworkName() != null && machineConfig.getNetworkName().equals("localhost") ? LibVirtLocalMachine.from(this.injector, this, machineConfig) : LibVirtMachine.from(this.injector, this, machineConfig, ipAddress);
        this.addMachine((Machine)machine);
    }

    private synchronized void addMachine(Machine machine) {
        this.machines.put(machine.getConfig().getName(), machine);
    }

    private Habitat getHabitat() {
        return Dom.unwrap((ConfigBeanProxy)this.config).getHabitat();
    }

    public PhasedFuture<AllocationPhase, VirtualMachine> allocate(TemplateInstance template, VirtualCluster cluster, EventSource<AllocationPhase> source) throws VirtException {
        Machine machine;
        int park = this.size();
        if (park == 0) {
            throw new VirtException("Cannot allocate virtual machine to a serverPool with no machine");
        }
        Iterator<? extends Machine> machines = this.machines().iterator();
        int machineTried = 0;
        do {
            if (!machines.hasNext()) {
                machines = this.machines().iterator();
            }
            machine = machines.next();
            ++machineTried;
            if (machine.isUp()) continue;
            RuntimeContext.logger.info("Waking up machine " + machine.getName());
            try {
                Habitat habitat = Dom.unwrap((ConfigBeanProxy)this.config).getHabitat();
                ((OsInterface)habitat.getComponent(OsInterface.class)).resume(machine);
            }
            catch (IOException e) {
                RuntimeContext.logger.log(Level.SEVERE, "Error while waking up machine " + machine.getName(), e);
            }
            int tries = 0;
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (!machine.isUp() && ++tries < 5);
            if (machine.isUp()) continue;
            RuntimeContext.logger.log(Level.SEVERE, "Cannot wake up machine " + machine.getConfig().getDisksLocation());
        } while (!machine.isUp() || machineTried > park);
        if (!machine.isUp()) {
            RuntimeContext.logger.log(Level.SEVERE, "All the machines of this serverPool are shutdown and cannot be started");
            throw new VirtException("Cannot start any of the serverPool's machine");
        }
        Machine targetMachine = machine;
        this.allocationCount.incrementAndGet();
        PhasedFuture vm = null;
        try {
            vm = targetMachine.create(template, cluster, source);
        }
        catch (IOException e) {
            throw new VirtException((Throwable)e);
        }
        RuntimeContext.logger.info("Virtual machine allocated in serverPool " + this.getName() + " for cluster " + cluster.getConfig().getName());
        return vm;
    }

    public void install(TemplateInstance template) throws IOException {
        IOException lastException = null;
        for (Machine machine : this.machines.values()) {
            try {
                machine.install(template);
            }
            catch (IOException e) {
                lastException = e;
                RuntimeContext.logger.log(Level.SEVERE, "Error while installing template " + template.getConfig().getName() + " on " + machine.getName(), e);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }
}

