/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.VirtualMachineConfig;
import org.glassfish.virtualization.libvirt.jna.Domain;
import org.glassfish.virtualization.libvirt.jna.DomainInfo;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.MemoryListener;
import org.glassfish.virtualization.spi.ServerPool;
import org.glassfish.virtualization.spi.StorageVol;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.spi.VirtualMachineInfo;
import org.glassfish.virtualization.util.AbstractVirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibVirtVirtualMachine
extends AbstractVirtualMachine {
    private final Machine owner;
    private final Domain domain;
    private final List<StorageVol> storageVols;
    private final String name;
    private InetAddress address;

    protected LibVirtVirtualMachine(VirtualMachineConfig config, VirtUser user, Machine owner, Domain domain, List<StorageVol> storageVols) throws VirtException {
        super(config, user);
        this.domain = domain;
        this.owner = owner;
        this.name = domain.getName();
        this.storageVols = new ArrayList<StorageVol>(storageVols);
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void start() throws VirtException {
        this.domain.create();
    }

    public void stop() throws VirtException {
        if (DomainInfo.DomainState.VIR_DOMAIN_RUNNING.equals((Object)this.domain.getInfo().getState())) {
            this.domain.destroy();
        }
    }

    public void resume() throws VirtException {
        this.domain.resume();
    }

    public void suspend() throws VirtException {
        this.domain.suspend();
    }

    public String getName() {
        return this.name;
    }

    public void delete() throws VirtException {
        try {
            this.stop();
        }
        catch (VirtException e) {
            e.printStackTrace();
        }
        for (StorageVol volume : this.storageVols) {
            String volumeName = volume.getName();
            try {
                volume.delete();
            }
            catch (VirtException e) {
                RuntimeContext.logger.log(Level.SEVERE, "Error while deleting the " + volumeName + " virtual machine disk", e);
            }
            RuntimeContext.logger.log(Level.INFO, this.getName() + " disk " + volume.getName() + " deleted successfully");
        }
        this.domain.undefine();
    }

    public VirtualMachineInfo getInfo() {
        return new VirtualMachineInfo(){
            private final Map<MemoryListener, ScheduledFuture> listeners = new HashMap<MemoryListener, ScheduledFuture>();

            public int nbVirtCpu() throws VirtException {
                return ((LibVirtVirtualMachine)LibVirtVirtualMachine.this).domain.getInfo().nrVirtCpu;
            }

            public long memory() throws VirtException {
                return ((LibVirtVirtualMachine)LibVirtVirtualMachine.this).domain.getInfo().memory.longValue();
            }

            public long cpuTime() throws VirtException {
                return ((LibVirtVirtualMachine)LibVirtVirtualMachine.this).domain.getInfo().cpuTime;
            }

            public long maxMemory() throws VirtException {
                return ((LibVirtVirtualMachine)LibVirtVirtualMachine.this).domain.getInfo().maxMem.longValue();
            }

            public Machine.State getState() throws VirtException {
                try {
                    DomainInfo.DomainState state = DomainInfo.DomainState.values()[((LibVirtVirtualMachine)LibVirtVirtualMachine.this).domain.getInfo().state];
                    if (DomainInfo.DomainState.VIR_DOMAIN_RUNNING.equals((Object)state) || DomainInfo.DomainState.VIR_DOMAIN_BLOCKED.equals((Object)state)) {
                        return Machine.State.READY;
                    }
                    if (DomainInfo.DomainState.VIR_DOMAIN_SHUTDOWN.equals((Object)state)) {
                        return Machine.State.SUSPENDING;
                    }
                    return Machine.State.SUSPENDED;
                }
                catch (VirtException e) {
                    throw new VirtException((Throwable)e);
                }
            }

            public void registerMemoryListener(final MemoryListener ml, long period, TimeUnit unit) {
                ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
                LibVirtVirtualMachine owner = LibVirtVirtualMachine.this;
                this.listeners.put(ml, executor.schedule(new Runnable((VirtualMachine)owner){
                    final /* synthetic */ VirtualMachine val$owner;
                    {
                        this.val$owner = virtualMachine;
                    }

                    public void run() {
                        try {
                            ml.notified(this.val$owner, this.memory(), this.cpuTime());
                        }
                        catch (VirtException e) {
                            RuntimeContext.logger.log(Level.FINE, "Exception while notifying of vm load ", e);
                        }
                    }
                }, period, unit));
            }

            public void unregisterMemoryListener(MemoryListener ml) {
                this.listeners.get(ml).cancel(false);
            }
        };
    }

    public ServerPool getServerPool() {
        return this.owner.getServerPool();
    }

    public Machine getMachine() {
        return this.owner;
    }

    public String executeOn(String[] args) throws IOException, InterruptedException {
        SSHLauncher sshLauncher = new SSHLauncher();
        File home = new File(System.getProperty("user.home"));
        String keyFile = new File(home, ".ssh/id_dsa").getAbsolutePath();
        sshLauncher.init(this.getUser().getName(), this.address.getHostAddress(), 22, null, keyFile, null, Logger.getAnonymousLogger());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder stringBuilder = new StringBuilder();
        for (String arg : args) {
            stringBuilder.append(arg);
            stringBuilder.append(" ");
        }
        sshLauncher.runCommand(stringBuilder.toString().trim(), (OutputStream)baos);
        return baos.toString();
    }
}

