/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.virtualization.spi.FileOperations;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.util.RuntimeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SSHFileOperations
implements FileOperations {
    final SSHLauncher sshLauncher;
    final Machine machine;
    final ThreadLocal<ClientTuple> sftpClientThreadLocal = new ThreadLocal();

    SSHFileOperations(Machine machine, SSHLauncher sshLauncher) throws IOException {
        this.sshLauncher = sshLauncher;
        this.machine = machine;
    }

    synchronized void close() throws IOException {
        this.getSFTPClient().close();
    }

    private synchronized SFTPClient getSFTPClient() throws IOException {
        ClientTuple clients = this.sftpClientThreadLocal.get();
        if (clients == null) {
            clients = this.init();
            this.sftpClientThreadLocal.set(clients);
        }
        return clients.sftpClient;
    }

    private synchronized SCPClient getSCPClient() throws IOException {
        ClientTuple clients = this.sftpClientThreadLocal.get();
        if (clients == null) {
            clients = this.init();
            this.sftpClientThreadLocal.set(clients);
        }
        return clients.scpClient;
    }

    private ClientTuple init() throws IOException {
        File home = new File(System.getProperty("user.home"));
        String keyFile = new File(home, ".ssh/id_dsa").getAbsolutePath();
        this.sshLauncher.init(this.machine.getUser().getName(), this.machine.getIpAddress(), 22, null, keyFile, null, Logger.getAnonymousLogger());
        return new ClientTuple(this.sshLauncher.getSFTPClient(), this.sshLauncher.getSCPClient());
    }

    public boolean mkdir(String path) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        if (!sftpClient.exists(path)) {
            sftpClient.mkdirs(path, 493);
            return true;
        }
        return false;
    }

    public boolean delete(String path) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        if (sftpClient.exists(path)) {
            SFTPv3FileAttributes atts = sftpClient._stat(path);
            if (atts != null && atts.isDirectory()) {
                System.out.println("Going to delete directory " + path);
                if (path.contains("cached")) {
                    Thread.dumpStack();
                }
                this.deleteDirectory(sftpClient, path);
            } else {
                sftpClient.rm(path);
            }
            return true;
        }
        return false;
    }

    private boolean deleteDirectory(SFTPClient sftpClient, String path) throws IOException {
        for (String fileName : this.ls(path)) {
            String filePath = path + File.separatorChar + fileName;
            SFTPv3FileAttributes atts = sftpClient._stat(filePath);
            if (atts != null && atts.isDirectory()) {
                this.deleteDirectory(sftpClient, filePath);
                continue;
            }
            sftpClient.rm(filePath);
        }
        sftpClient.rmdir(path);
        return true;
    }

    public synchronized boolean mv(String source, String dest) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        if (this.exists(dest)) {
            this.delete(dest);
        }
        sftpClient.mv(source, dest);
        return true;
    }

    public synchronized long length(String path) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        return sftpClient.lstat((String)path).size;
    }

    public synchronized boolean exists(String path) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        return sftpClient.exists(path);
    }

    public synchronized Date mod(String path) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        long mTimeinSeconds = sftpClient._stat((String)path).mtime.intValue();
        return new Date(mTimeinSeconds * 1000L);
    }

    public void copy(File source, File destination) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        this.mkdirs(destination);
        String destPath = destination + "/" + source.getName();
        if (sftpClient.exists(destPath)) {
            sftpClient.rm(destPath);
        }
        this.getSCPClient().put(source.getAbsolutePath(), destination.getPath());
    }

    public synchronized void localCopy(String source, String destDir) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        try {
            if (!sftpClient.exists(destDir)) {
                sftpClient.mkdirs(destDir, 493);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            RuntimeContext.logger.info("Remote cp file " + source + " on " + this.machine.getName());
            this.sshLauncher.runCommand("cp " + source + " " + destDir, (OutputStream)baos);
        }
        catch (IOException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Cannot copy file on " + this.machine.getName(), e);
            throw e;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public List<String> ls(String path) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        Vector vector = sftpClient.ls(path);
        ArrayList<String> filePaths = new ArrayList<String>();
        for (SFTPv3DirectoryEntry element : vector) {
            if (element.filename.equals(".") || element.filename.equals("..")) continue;
            filePaths.add(element.filename);
        }
        return filePaths;
    }

    public synchronized void mkdirs(File path) throws IOException {
        SFTPClient sftpClient = this.getSFTPClient();
        if (path.getParentFile() != null) {
            this.mkdirs(path.getParentFile());
        }
        if (!sftpClient.exists(path.getPath())) {
            sftpClient.mkdirs(path.getPath(), 493);
        }
    }

    private static final class ClientTuple {
        final SFTPClient sftpClient;
        final SCPClient scpClient;

        private ClientTuple(SFTPClient sftpClient, SCPClient scpClient) {
            this.sftpClient = sftpClient;
            this.scpClient = scpClient;
        }
    }
}

