/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.hk2.scopes.PerLookup;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.libvirt.config.LibvirtVirtualization;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-ims-config-libvirt")
@Scoped(value=PerLookup.class)
public class CreateLibVirtVirtualization
implements AdminCommand {
    @Param(optional=true, defaultValue="/usr/bin/kvm")
    String emulatorPath;
    @Param(optional=true, defaultValue="qemu#{auth.sep}#{auth.method}://#{user.name}@#{target.host}/system")
    String connectionString;
    @Param(primary=true)
    String virtName;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        RuntimeContext.ensureTopLevelConfig((Domain)this.domain, (ActionReport)context.getActionReport());
        if (context.getActionReport().hasFailures()) {
            return;
        }
        Virtualizations virts = (Virtualizations)this.domain.getExtensionByType(Virtualizations.class);
        if (virts.byName("libvirt") != null) {
            context.getActionReport().failure(RuntimeContext.logger, "Libvirt virtualization already configured");
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Virtualizations>(){

                public Object run(Virtualizations wVirts) throws PropertyVetoException, TransactionFailure {
                    LibvirtVirtualization virt = (LibvirtVirtualization)wVirts.createChild(LibvirtVirtualization.class);
                    virt.setName(CreateLibVirtVirtualization.this.virtName);
                    virt.setType("libvirt");
                    virt.setConnectionString(CreateLibVirtVirtualization.this.connectionString);
                    virt.setEmulatorPath(CreateLibVirtVirtualization.this.emulatorPath);
                    wVirts.getVirtualizations().add(virt);
                    return virt;
                }
            }, (ConfigBeanProxy)virts);
        }
        catch (TransactionFailure transactionFailure) {
            context.getActionReport().failure(RuntimeContext.logger, "Cannot create libvirt virtualizations configuration", (Throwable)transactionFailure);
            return;
        }
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

