/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.virtualization.config.ServerPoolConfig;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;

@Configured
public interface MachineConfig
extends ConfigBeanProxy {
    @Attribute(key=true)
    public String getName();

    @Param(primary=true, name="name")
    public void setName(String var1);

    @Element
    public String getNetworkName();

    @Param(optional=true, name="networkName")
    public void setNetworkName(String var1);

    @Element
    public String getIpAddress();

    @Param(optional=true, name="ip")
    public void setIpAddress(String var1);

    @Element
    public String getMacAddress();

    @Param(optional=true, name="mac")
    public void setMacAddress(String var1);

    @Attribute
    public String getOsName();

    public void setOsName(String var1);

    @Attribute(defaultValue="virt/disks")
    public String getDisksLocation();

    @Param(optional=true)
    public void setDisksLocation(String var1);

    @Attribute(defaultValue="virt/templates")
    public String getTemplatesLocation();

    @Param(optional=true)
    public void setTemplatesLocation(String var1);

    @Attribute(defaultValue="virt/cache")
    public String getTemplateCacheLocation();

    @Param(optional=true)
    public void setTemplateCacheLocation(String var1);

    @Element
    public VirtUser getUser();

    @Create(value="create-machine-user", resolver=MachineResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-machine"))
    public void setUser(VirtUser var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class MachineResolver
    implements CrudResolver {
        @Param(name="serverPool")
        String serverPool;
        @Param(name="machine")
        String machine;
        @Param(optional=true)
        String virtualization = null;
        @Inject
        Virtualizations virts;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            Virtualization virt = this.virtualization == null ? this.virts.getVirtualizations().get(0) : this.virts.byName(this.virtualization);
            ServerPoolConfig config = virt.serverPoolByName(this.serverPool);
            if (config != null) {
                return (T)config.machineByName(this.machine);
            }
            context.getActionReport().failure(context.getLogger(), "Cannot find a machine by the name of " + this.machine);
            return null;
        }
    }
}

