/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.Listing;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.jvnet.hk2.annotations.Decorate;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
@Create(value="create-serverPool-manager", resolver=Virtualization.VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-serverPool-manager"))
@Decorate(targetType=Domain.class, methodName="getExtensions", with={Create.class})
public interface ServerPoolConfig
extends ConfigBeanProxy {
    @Attribute(key=true)
    public String getName();

    @Param(name="name", primary=true)
    public void setName(String var1);

    @Attribute
    public String getPortName();

    @Param(name="portName")
    public void setPortName(String var1);

    @Attribute
    public String getSubNet();

    @Param(name="subNet")
    public void setSubNet(String var1);

    @Element
    @NotNull
    public VirtUser getUser();

    @Create(value="create-server-pool-user", resolver=ServerPoolResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-machine"))
    public void setUser(VirtUser var1);

    @Element
    @Create(value="create-machine", resolver=ServerPoolResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-machine"))
    @Listing(value="list-machines", resolver=ServerPoolResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-machines"))
    @Delete(value="delete-machine", resolver=WithinGroupResolver.class, i18n=@I18n(value="org.glassfish.virtualization.delete-machine"))
    public List<MachineConfig> getMachines();

    @DuckTyped
    public MachineConfig machineByName(String var1);

    @DuckTyped
    public Virtualization getVirtualization();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class WithinGroupResolver
    extends ServerPoolResolver {
        @Param(primary=true)
        String name;

        @Override
        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            ServerPoolConfig serverPool = (ServerPoolConfig)super.resolve(context, type);
            if (serverPool != null) {
                MachineConfig mc = serverPool.machineByName(this.name);
                if (mc != null) {
                    return (T)mc;
                }
                context.getActionReport().failure(context.getLogger(), "Cannot find a machine by the name of " + serverPool);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class ServerPoolResolver
    implements CrudResolver {
        @Param(name="serverPool")
        String group;
        @Param(optional=true)
        String virtualization;
        @Inject
        Virtualizations virts;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            Virtualization virt = this.virtualization == null ? this.virts.getVirtualizations().get(0) : this.virts.byName(this.virtualization);
            ServerPoolConfig config = virt.serverPoolByName(this.group);
            if (config != null) {
                return (T)config;
            }
            context.getActionReport().failure(context.getLogger(), "Cannot find a serverPool by the name of " + this.group);
            return null;
        }
    }

    public static class Duck {
        public static MachineConfig machineByName(ServerPoolConfig self, String name) {
            for (MachineConfig mc : self.getMachines()) {
                if (!mc.getName().equals(name)) continue;
                return mc;
            }
            return null;
        }

        public static Virtualization getVirtualization(ServerPoolConfig self) {
            return (Virtualization)self.getParent();
        }
    }
}

