/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.virtualization.config.TemplateIndex;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Template
extends ConfigBeanProxy,
Named {
    public void setName(String var1);

    @Element(value="*")
    public List<TemplateIndex> getIndexes();

    @Element
    public VirtUser getUser();

    @Create(value="create-template-user", resolver=TemplateResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-machine"))
    public void setUser(VirtUser var1);

    @Element
    public List<Property> getProperties();

    @DuckTyped
    public TemplateIndex byName(String var1);

    @DuckTyped
    public Virtualization getVirtualization();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class TemplateResolver
    implements CrudResolver {
        @Param
        String template;
        @Param
        String virtualization;
        @Inject
        Virtualizations virts;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            Virtualization virt = this.virts.byName(this.virtualization);
            if (virt == null) {
                Logger.getLogger("javax.enterprise.system.core.config").log(Level.SEVERE, "Cannot find a virtualization setting named " + this.virtualization);
                return null;
            }
            Template thisTemplate = virt.templateByName(this.template);
            return (T)thisTemplate;
        }
    }

    public static class Duck {
        public static TemplateIndex byName(Template self, String name) {
            for (TemplateIndex ti : self.getIndexes()) {
                if (!ti.getType().equals(name)) continue;
                return ti;
            }
            return null;
        }

        public static Virtualization getVirtualization(Template self) {
            return (Virtualization)Virtualization.class.cast(self.getParent());
        }
    }
}

