/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.VirtualMachineExtension;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.glassfish.api.admin.AdminCommandLock;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.api.admin.config.Named;
import org.glassfish.virtualization.config.ServerPoolConfig;
import org.glassfish.virtualization.config.Template;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
@RestRedirects(value={@RestRedirect(opType=RestRedirect.OpType.GET, commandName="register-virtual-machine"), @RestRedirect(opType=RestRedirect.OpType.GET, commandName="register-startup")})
public interface VirtualMachineConfig
extends Named,
ConfigBeanProxy,
VirtualMachineExtension {
    @Attribute(reference=true)
    public Template getTemplate();

    public void setTemplate(Template var1);

    @Attribute(reference=true)
    public ServerPoolConfig getServerPool();

    public void setServerPool(ServerPoolConfig var1);

    @Element
    public List<Property> getProperty();

    public static class Utils {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static VirtualMachineConfig create(final String name, final Template template, final ServerPoolConfig serverPool, Cluster cluster) {
            Habitat habitat = Dom.unwrap((ConfigBeanProxy)cluster).getHabitat();
            AdminCommandLock adminCommandLock = (AdminCommandLock)habitat.getComponent(AdminCommandLock.class);
            Lock lock = null;
            try {
                lock = adminCommandLock.getLock(CommandLock.LockType.SHARED);
                lock.lock();
                VirtualMachineConfig virtualMachineConfig = (VirtualMachineConfig)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Cluster>(){

                    public Object run(Cluster wCluster) throws PropertyVetoException, TransactionFailure {
                        VirtualMachineConfig vmConfig = (VirtualMachineConfig)wCluster.createChild(VirtualMachineConfig.class);
                        vmConfig.setName(name);
                        vmConfig.setTemplate(template);
                        vmConfig.setServerPool(serverPool);
                        wCluster.getExtensions().add(vmConfig);
                        return vmConfig;
                    }
                }, (ConfigBeanProxy)cluster);
                if (lock != null) {
                    lock.unlock();
                }
                return virtualMachineConfig;
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        lock.unlock();
                    }
                    throw throwable;
                }
                catch (TransactionFailure transactionFailure) {
                    throw new RuntimeException(transactionFailure);
                }
            }
        }
    }
}

