/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import java.beans.PropertyVetoException;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.Listing;
import org.glassfish.config.support.TypeAndNameResolver;
import org.glassfish.virtualization.config.Action;
import org.glassfish.virtualization.config.GroupManager;
import org.glassfish.virtualization.config.ServerPoolConfig;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualizations;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Virtualization
extends ConfigBeanProxy {
    @Attribute(key=true)
    public String getName();

    public void setName(String var1);

    @Attribute
    @NotNull
    public String getType();

    public void setType(String var1);

    @Attribute(defaultValue="5")
    public String getTemplateCacheSize();

    public void setTemplateCacheSize(String var1);

    @Attribute(defaultValue="120")
    public String getTemplateCacheRefreshRate();

    public void setTemplateCacheRefreshRate(String var1);

    @Element(value="template")
    @Listing(value="list-templates", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-templates"))
    @Delete(value="remove-template", resolver=TypeAndNameResolver.class, i18n=@I18n(value="org.glassfish.virtualization.remove-template"))
    public List<Template> getTemplates();

    @Element(value="server-pool-master")
    @Listing(value="list-group-master", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-serverPool-managers"))
    @Delete(value="delete-group-master", resolver=TypeAndNameResolver.class, i18n=@I18n(value="org.glassfish.virtualization.delete-serverPool-manager"))
    public List<GroupManager> getServerPoolMaster();

    @Element(value="server-pool")
    @Create(value="create-server-pool", resolver=VirtResolver.class, decorator=ServerPoolDecorator.class, i18n=@I18n(value="org.glassfish.virtualization.create-virt-serverPool"))
    @Listing(value="list-server-pools", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-virt-groups"))
    @Delete(value="delete-server-pool", resolver=TypeAndNameResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-virt-serverPool"))
    public List<ServerPoolConfig> getServerPools();

    @Element
    public String getScriptsLocation();

    public void setScriptsLocation(String var1);

    @Element(value="action")
    public List<Action> getActions();

    @DuckTyped
    public Template templateByName(String var1);

    @DuckTyped
    public ServerPoolConfig serverPoolByName(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class ServerPoolDecorator
    implements CreationDecorator<ServerPoolConfig> {
        public void decorate(AdminCommandContext context, ServerPoolConfig instance) throws TransactionFailure, PropertyVetoException {
            VirtUser user = (VirtUser)instance.createChild(VirtUser.class);
            instance.setUser(user);
        }
    }

    public static class Duck {
        public static Template templateByName(Virtualization self, String name) {
            for (Template template : self.getTemplates()) {
                if (!template.getName().equals(name)) continue;
                return template;
            }
            return null;
        }

        public static ServerPoolConfig serverPoolByName(Virtualization self, String name) {
            for (ServerPoolConfig groupConfig : self.getServerPools()) {
                if (!groupConfig.getName().equals(name)) continue;
                return groupConfig;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class VirtResolver
    implements CrudResolver {
        @Param
        String virtualization;
        @Inject
        Virtualizations virtualizations;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            return (T)this.virtualizations.byName(this.virtualization);
        }
    }
}

