/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.glassfish.virtualization.spi.ServerPool;
import org.glassfish.virtualization.spi.StaticVirtualMachineInfo;
import org.glassfish.virtualization.spi.TemplateInstance;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocationConstraints {
    final TemplateInstance template;
    final VirtualCluster targetCluster;
    final List<ServerPool> groups = new ArrayList<ServerPool>();
    final List<VirtualMachine> noColocationList = new ArrayList<VirtualMachine>();
    final Properties vmProps = new Properties();

    public AllocationConstraints(TemplateInstance template, VirtualCluster targetCluster) {
        this.template = template;
        this.targetCluster = targetCluster;
    }

    public VirtualCluster getTargetCluster() {
        return this.targetCluster;
    }

    public StaticVirtualMachineInfo getCharacteristics() {
        return null;
    }

    public AllocationConstraints in(ServerPool ... groups) {
        this.groups.addAll(Arrays.asList(groups));
        return this;
    }

    public AllocationConstraints noColocationWith(VirtualMachine ... vms) {
        this.noColocationList.addAll(Arrays.asList(vms));
        return this;
    }

    public Properties getVirtualMachineProperties() {
        return this.vmProps;
    }

    public Collection<ServerPool> affinities() {
        return Collections.unmodifiableList(this.groups);
    }

    public List<VirtualMachine> separateFrom() {
        return Collections.unmodifiableList(this.noColocationList);
    }

    public TemplateInstance getTemplate() {
        return this.template;
    }
}

