/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.spi;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.spi.AllocationPhase;
import org.glassfish.virtualization.spi.EventSource;
import org.glassfish.virtualization.spi.MachineOperations;
import org.glassfish.virtualization.spi.PhasedFuture;
import org.glassfish.virtualization.spi.PhysicalServerPool;
import org.glassfish.virtualization.spi.StoragePool;
import org.glassfish.virtualization.spi.TemplateInstance;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Machine {
    public MachineConfig getConfig();

    public String getName();

    public String getIpAddress();

    public PhysicalServerPool getServerPool();

    public State getState();

    public VirtUser getUser();

    public <T> T execute(MachineOperations<T> var1) throws IOException;

    public boolean isUp();

    public void sleep() throws IOException, InterruptedException;

    public Collection<? extends VirtualMachine> getVMs() throws VirtException;

    public StoragePool addStoragePool(String var1, long var2) throws VirtException;

    public Map<String, ? extends StoragePool> getStoragePools() throws VirtException;

    public VirtualMachine byName(String var1) throws VirtException;

    public PhasedFuture<AllocationPhase, VirtualMachine> create(TemplateInstance var1, VirtualCluster var2, EventSource<AllocationPhase> var3) throws VirtException, IOException;

    public void install(TemplateInstance var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        SUSPENDING,
        SUSPENDED,
        RESUMING,
        READY;

    }
}

