/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.spi;

import com.sun.enterprise.config.serverbeans.Cluster;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.virtualization.config.ServerPoolConfig;
import org.glassfish.virtualization.config.VirtualMachineConfig;
import org.glassfish.virtualization.spi.IAAS;
import org.glassfish.virtualization.spi.ServerPool;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualCluster {
    final Cluster config;
    final AtomicInteger token = new AtomicInteger();
    final List<VirtualMachine> vms = new ArrayList<VirtualMachine>();

    public VirtualCluster(IAAS iaas, Cluster config) throws VirtException {
        this.config = config;
        this.token.set(config.getServerRef().size());
        for (VirtualMachineConfig vm : config.getExtensionsByType(VirtualMachineConfig.class)) {
            ServerPoolConfig serverPoolConfig = vm.getServerPool();
            ServerPool serverPool = iaas.byName(serverPoolConfig.getName());
            VirtualMachine virtualMachine = serverPool.vmByName(vm.getName());
            if (virtualMachine == null) continue;
            this.vms.add(virtualMachine);
        }
    }

    public Cluster getConfig() {
        return this.config;
    }

    public synchronized int allocateToken() {
        return this.token.addAndGet(1);
    }

    public synchronized void add(VirtualMachine vm) {
        this.vms.add(vm);
    }

    public synchronized void remove(final VirtualMachine vm) {
        try {
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                    Cluster wCluster = (Cluster)params[0];
                    VirtualMachineConfig vmConfig = (VirtualMachineConfig)VirtualCluster.this.config.getExtensionsByTypeAndName(VirtualMachineConfig.class, vm.getName());
                    if (vmConfig == null) {
                        throw new TransactionFailure("Cannot find virtual machine configuration under cluster");
                    }
                    wCluster.getExtensions().remove(vmConfig);
                    return null;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.config, vm.getServerPool().getConfig()});
        }
        catch (TransactionFailure transactionFailure) {
            throw new RuntimeException(transactionFailure);
        }
        this.vms.remove(vm);
    }

    public void delete() {
        ArrayList<VirtualMachine> copy = new ArrayList<VirtualMachine>();
        copy.addAll(this.vms);
        for (VirtualMachine vm : copy) {
            this.remove(vm);
        }
    }

    public VirtualMachine vmByName(String name) {
        for (VirtualMachine vm : this.vms) {
            if (!vm.getName().equals(name)) continue;
            return vm;
        }
        return null;
    }

    public synchronized List<VirtualMachine> getVMs() {
        return Collections.unmodifiableList(this.vms);
    }
}

