/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.virtualbox;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.OS;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.hk2.scopes.PerLookup;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.util.RuntimeContext;
import org.glassfish.virtualization.virtualbox.VirtualBoxVirtualization;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-ims-config-virtualbox")
@Scoped(value=PerLookup.class)
public class CreateVirtualBoxVirtualization
implements AdminCommand {
    @Param(optional=true)
    String emulatorPath = null;
    @Param(primary=true)
    String name;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        if (this.emulatorPath == null) {
            this.emulatorPath = this.getDefaultEmulatorPath();
        }
        if (this.emulatorPath == null) {
            context.getActionReport().failure(RuntimeContext.logger, "No emulator path provided");
            return;
        }
        RuntimeContext.ensureTopLevelConfig((Domain)this.domain, (ActionReport)context.getActionReport());
        if (context.getActionReport().hasFailures()) {
            return;
        }
        Virtualizations virts = (Virtualizations)this.domain.getExtensionByType(Virtualizations.class);
        if (virts.byName("virtualbox") != null) {
            context.getActionReport().failure(RuntimeContext.logger, "VirtualBox virtualization already configured");
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Virtualizations>(){

                public Object run(Virtualizations wVirts) throws PropertyVetoException, TransactionFailure {
                    VirtualBoxVirtualization virt = (VirtualBoxVirtualization)wVirts.createChild(VirtualBoxVirtualization.class);
                    virt.setName(CreateVirtualBoxVirtualization.this.name);
                    virt.setType("virtualbox");
                    virt.setEmulatorPath(CreateVirtualBoxVirtualization.this.emulatorPath);
                    wVirts.getVirtualizations().add(virt);
                    return virt;
                }
            }, (ConfigBeanProxy)virts);
        }
        catch (TransactionFailure transactionFailure) {
            context.getActionReport().failure(RuntimeContext.logger, "Cannot create virtualbox virtualization configuration", (Throwable)transactionFailure);
            return;
        }
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private String getDefaultEmulatorPath() {
        if (OS.isDarwin()) {
            return "/Applications/VirtualBoxVirtualization.app/Contents/MacOS";
        }
        return null;
    }
}

