/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.virtualbox;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.ServerPoolConfig;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.VirtualMachineConfig;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.runtime.AbstractMachine;
import org.glassfish.virtualization.runtime.VirtualMachineLifecycle;
import org.glassfish.virtualization.spi.AllocationPhase;
import org.glassfish.virtualization.spi.Disk;
import org.glassfish.virtualization.spi.EventSource;
import org.glassfish.virtualization.spi.FileOperations;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.MachineOperations;
import org.glassfish.virtualization.spi.PhasedFuture;
import org.glassfish.virtualization.spi.PhysicalServerPool;
import org.glassfish.virtualization.spi.StoragePool;
import org.glassfish.virtualization.spi.TemplateInstance;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.Host;
import org.glassfish.virtualization.util.ListenableFutureImpl;
import org.glassfish.virtualization.util.RuntimeContext;
import org.glassfish.virtualization.virtualbox.ConnectionManager;
import org.glassfish.virtualization.virtualbox.VBoxGroup;
import org.glassfish.virtualization.virtualbox.VBoxVirtualMachine;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.virtualbox_4_1.AccessMode;
import org.virtualbox_4_1.DeviceType;
import org.virtualbox_4_1.IHostNetworkInterface;
import org.virtualbox_4_1.IMachine;
import org.virtualbox_4_1.IMedium;
import org.virtualbox_4_1.INetworkAdapter;
import org.virtualbox_4_1.IProgress;
import org.virtualbox_4_1.ISession;
import org.virtualbox_4_1.IStorageController;
import org.virtualbox_4_1.IVirtualBox;
import org.virtualbox_4_1.LockType;
import org.virtualbox_4_1.NetworkAdapterType;
import org.virtualbox_4_1.NetworkAttachmentType;
import org.virtualbox_4_1.StorageBus;
import org.virtualbox_4_1.VirtualBoxManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VBoxLocalMachine
extends AbstractMachine
implements PostConstruct {
    final Map<String, VBoxVirtualMachine> domains = new HashMap<String, VBoxVirtualMachine>();
    @Inject
    Virtualizations virtualizations;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;
    @Inject
    VirtualMachineLifecycle vmLifecycle;
    @Inject
    Host host;

    public static VBoxLocalMachine from(Injector injector, VBoxGroup group, MachineConfig config) {
        return (VBoxLocalMachine)((Object)injector.inject((Object)new VBoxLocalMachine(group, config)));
    }

    protected VBoxLocalMachine(VBoxGroup group, MachineConfig config) {
        super((PhysicalServerPool)group, config);
    }

    public void postConstruct() {
        this.setState(this.isUp() ? Machine.State.READY : Machine.State.SUSPENDED);
        super.postConstruct();
    }

    public StoragePool addStoragePool(String name, long capacity) throws VirtException {
        return null;
    }

    public String description() {
        StringBuffer sb = new StringBuffer();
        sb.append("Machine ").append(this.getName());
        return sb.toString();
    }

    public Collection<? extends VirtualMachine> getVMs() throws VirtException {
        try {
            VirtualBoxManager mgr = ConnectionManager.connection(this.getIpAddress());
            List<IMachine> machs = mgr.getVBox().getMachines();
            for (IMachine m : machs) {
                try {
                    String domainName = m.getName();
                    if (this.domains.containsKey(domainName)) continue;
                    for (Cluster cluster : this.domain.getClusters().getCluster()) {
                        for (VirtualMachineConfig vmc : cluster.getExtensionsByType(VirtualMachineConfig.class)) {
                            if (!vmc.getName().equals(domainName)) continue;
                            VBoxVirtualMachine gfVM = new VBoxVirtualMachine(vmc, vmc.getTemplate().getUser(), (Machine)this, domainName);
                            this.domains.put(domainName, gfVM);
                        }
                    }
                }
                catch (Exception e) {
                }
            }
            mgr.disconnect();
            mgr.cleanup();
        }
        catch (Exception e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of domains ", e);
            throw new VirtException((Throwable)e);
        }
        return this.domains.values();
    }

    public Map<String, ? extends StoragePool> getStoragePools() throws VirtException {
        return null;
    }

    public VirtualMachine byName(String name) throws VirtException {
        if (!this.domains.containsKey(name)) {
            try {
                this.getVMs();
            }
            catch (VirtException e) {
                RuntimeContext.logger.log(Level.SEVERE, "Exception while populating list of domains ", e);
            }
        }
        return (VirtualMachine)this.domains.get(name);
    }

    public void sleep() throws IOException, InterruptedException {
        throw new IOException("Impossible to put myself to sleep");
    }

    protected VirtualBoxManager connection() throws VirtException {
        return ConnectionManager.connection(this.getIpAddress());
    }

    public PhasedFuture<AllocationPhase, VirtualMachine> create(TemplateInstance template, VirtualCluster cluster, EventSource<AllocationPhase> source) throws VirtException, IOException {
        final String name = cluster.getConfig().getName() + cluster.allocateToken();
        source.fireEvent((Enum)AllocationPhase.VM_PREPARE);
        final String diskLocation = System.getProperty("user.home") + "/" + this.config.getDisksLocation();
        this.execute((MachineOperations)new MachineOperations<Object>(){

            public Object run(FileOperations fileOperations) throws IOException {
                fileOperations.mkdir(VBoxLocalMachine.this.config.getDisksLocation());
                fileOperations.delete(diskLocation + "/" + name + "cust.iso");
                fileOperations.delete(diskLocation + "/" + name + ".vdi");
                fileOperations.delete(diskLocation + "/" + name + ".vmdk");
                return null;
            }
        });
        File machineDisks = this.absolutize(new File(this.virtualizations.getDisksLocation(), this.serverPool.getName()));
        machineDisks = new File(machineDisks, this.getName());
        if (!machineDisks.exists() && !machineDisks.mkdirs()) {
            throw new IOException("cannot create disk cache on local machine");
        }
        this.createVboxVDIMachine(template.getConfig(), cluster, diskLocation, name);
        try {
            source.fireEvent((Enum)AllocationPhase.VM_SPAWN);
            CountDownLatch latch = this.vmLifecycle.inStartup(name);
            VirtualMachineConfig vmConfig = VirtualMachineConfig.Utils.create((String)name, (Template)template.getConfig(), (ServerPoolConfig)this.serverPool.getConfig(), (Cluster)cluster.getConfig());
            VBoxVirtualMachine vm = new VBoxVirtualMachine(vmConfig, template.getConfig().getUser(), (Machine)this, name);
            this.domains.put(name, vm);
            cluster.add((VirtualMachine)vm);
            ListenableFutureImpl future = new ListenableFutureImpl(latch, (Object)vm, source);
            future.fireEvent((Enum)AllocationPhase.VM_START);
            this.vmLifecycle.start((VirtualMachine)vm);
            return future;
        }
        catch (Exception e) {
            throw new VirtException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVboxVDIMachine(Template template, VirtualCluster cluster, String diskLocation, String name) throws VirtException {
        VirtualBoxManager connect = null;
        try {
            connect = ConnectionManager.connection(this.getIpAddress());
            IVirtualBox vbox = connect.getVBox();
            String machineName = name;
            IMachine iap = vbox.createMachine(null, machineName, "Linux", null, true);
            List<IStorageController> lsc = iap.getStorageControllers();
            for (IStorageController aaa : lsc) {
                System.out.println("storage controller " + aaa.getName());
            }
            iap.getUSBController().setEnabled(false);
            iap.setMemorySize(512L);
            String path = diskLocation + "/" + name + ".vdi";
            IMedium newm = vbox.createHardDisk("VDI", path);
            File templateDirLocation = new File(this.virtualizations.getTemplatesLocation(), template.getName());
            VDIFileFilter select = new VDIFileFilter();
            File[] contents = templateDirLocation.listFiles(select);
            if (contents == null || contents.length == 0) {
                throw new VirtException("No .vdi file in " + templateDirLocation.getAbsolutePath());
            }
            if (contents.length != 1) {
                throw new VirtException("there should be only 1 .vdi file in " + templateDirLocation.getAbsolutePath());
            }
            File VDITemplate = contents[0];
            IMedium im = vbox.openMedium(VDITemplate.getAbsolutePath(), DeviceType.HardDisk, AccessMode.ReadWrite, true);
            IProgress prog = im.cloneTo(newm, im.getVariant(), null);
            prog.waitForCompletion(-1);
            iap.addStorageController("SCSI Controller", StorageBus.SCSI);
            INetworkAdapter inadap = iap.getNetworkAdapter(0L);
            inadap.setEnabled(Boolean.FALSE);
            inadap.setAdapterType(NetworkAdapterType.I82540EM);
            inadap.setAttachmentType(NetworkAttachmentType.Bridged);
            String goodPortName = null;
            StringTokenizer portNames = new StringTokenizer(this.serverPool.getConfig().getPortName(), ";");
            block9: while (portNames.hasMoreTokens() && goodPortName == null) {
                String portName = portNames.nextToken();
                List<IHostNetworkInterface> lll = vbox.getHost().getNetworkInterfaces();
                for (IHostNetworkInterface imnet : lll) {
                    System.out.println("possible interface name= " + imnet.getName());
                    if (!imnet.getName().equals(portName)) continue;
                    goodPortName = portName;
                    continue block9;
                }
            }
            if (goodPortName == null) {
                throw new VirtException("Cannot find a good portName from this list: " + this.serverPool.getConfig().getPortName());
            }
            inadap.setBridgedInterface(goodPortName);
            inadap.setMACAddress(null);
            inadap.setEnabled(Boolean.TRUE);
            iap.addStorageController("IDE Controller", StorageBus.IDE);
            File ISOFile = this.createISOCustomization(template, cluster, name, diskLocation);
            IMedium cdrommedium = vbox.openMedium(ISOFile.getAbsolutePath(), DeviceType.DVD, AccessMode.ReadOnly, true);
            iap.saveSettings();
            vbox.registerMachine(iap);
            IMachine newMachine = vbox.findMachine(machineName);
            ISession session = connect.openMachineSession(newMachine);
            session.unlockMachine();
            try {
                newMachine.lockMachine(session, LockType.Write);
                IMedium im2 = vbox.openMedium(path, DeviceType.HardDisk, AccessMode.ReadWrite, true);
                session.getMachine().attachDevice("SCSI Controller", 0, 0, DeviceType.HardDisk, im2);
                session.getMachine().attachDevice("IDE Controller", 1, 0, DeviceType.DVD, cdrommedium);
                session.getMachine().saveSettings();
            }
            finally {
                session.unlockMachine();
            }
        }
        catch (Exception e) {
            throw new VirtException((Throwable)e);
        }
        finally {
            if (connect != null) {
                connect.disconnect();
                connect.cleanup();
            }
        }
    }

    private File getCustomizationDir(String machineAlias) {
        File custDir = null;
        try {
            File machineDisks = this.absolutize(new File(this.virtualizations.getDisksLocation(), this.serverPool.getName()));
            machineDisks = new File(machineDisks, this.getName());
            custDir = new File(machineDisks, machineAlias + "cust");
            if (!custDir.exists() && !custDir.mkdirs()) {
                throw new IOException("cannot create disk cache on local machine");
            }
            return custDir;
        }
        catch (Exception e) {
            return null;
        }
    }

    private File createISOCustomization(Template template, VirtualCluster cluster, String machineAlias, String diskLocation) throws VirtException {
        File custDir = this.getCustomizationDir(machineAlias);
        Disk custISO = (Disk)this.habitat.getComponent(Disk.class);
        try {
            custDir = this.prepareCustDirectory(machineAlias, cluster.getConfig(), template);
            File ret = new File(diskLocation + "/" + machineAlias + "cust.iso");
            custISO.createISOFromDirectory(custDir, ret);
            File file = ret;
            return file;
        }
        catch (Exception e) {
            throw new VirtException((Throwable)e);
        }
    }

    private static class VDIFileFilter
    implements FilenameFilter {
        private VDIFileFilter() {
        }

        public boolean accept(File directory, String filename) {
            return filename.endsWith(".vdi");
        }
    }
}

