/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.virtualbox;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.PhysicalServerPool;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.util.RuntimeContext;
import org.glassfish.virtualization.virtualbox.VBoxGroup;
import org.glassfish.virtualization.virtualbox.VBoxLocalMachine;
import org.jvnet.hk2.annotations.Inject;

class VBoxMachine
extends VBoxLocalMachine {
    final String ipAddress;
    @Inject
    SSHLauncher sshLauncher;

    public static VBoxMachine from(Injector injector, VBoxGroup group, MachineConfig config, String ipAddress) {
        return (VBoxMachine)((Object)injector.inject((Object)new VBoxMachine(group, config, ipAddress)));
    }

    protected VBoxMachine(VBoxGroup group, MachineConfig config, String ipAddress) {
        super(group, config);
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void mkdirs(SFTPClient client, File path) throws IOException {
        if (path.getParentFile() != null) {
            this.mkdirs(client, path.getParentFile());
        }
        if (!client.exists(path.getPath())) {
            client.mkdirs(path.getPath(), 493);
        }
    }

    public PhysicalServerPool getServerPool() {
        return this.serverPool;
    }

    public void ping() throws IOException, InterruptedException {
        SSHLauncher ssl = this.getSSH();
        ssl.pingConnection();
    }

    public void sleep() throws IOException, InterruptedException {
        SSHLauncher ssl = this.getSSH();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ssl.runCommand("sudo pm-suspend", (OutputStream)baos);
        System.out.println(baos.toString());
    }

    public boolean isUp() {
        if (Machine.State.READY.equals((Object)this.getState())) {
            return true;
        }
        if (this.getIpAddress() == null) {
            return false;
        }
        try {
            this.ping();
        }
        catch (Exception e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while pinging " + this.config.getName() + " : " + e.getMessage());
            RuntimeContext.logger.log(Level.FINE, "Exception while pinging " + this.config.getName(), e);
            return false;
        }
        try {
            this.connection();
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Cannot connect to machine " + this.config.getName() + " with the user " + this.serverPool.getConfig().getUser().getName(), e);
            return false;
        }
        return true;
    }

    public VirtUser getUser() {
        if (this.config.getUser() != null) {
            return this.config.getUser();
        }
        return this.serverPool.getConfig().getUser();
    }

    protected String getUserHome() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.getSSH().runCommand("echo $HOME", (OutputStream)baos);
        }
        catch (Exception e) {
            return "/home" + this.getUser().getName();
        }
        String userHome = baos.toString();
        return userHome.substring(0, userHome.length() - 1);
    }

    private SSHLauncher getSSH() {
        File home = new File(System.getProperty("user.home"));
        String keyFile = null;
        File rsa = new File(home, ".ssh/id_rsa");
        keyFile = rsa.exists() ? rsa.getAbsolutePath() : new File(home, ".ssh/id_dsa").getAbsolutePath();
        this.sshLauncher.init(this.getUser().getName(), this.ipAddress, 22, null, keyFile, null, Logger.getAnonymousLogger());
        return this.sshLauncher;
    }
}

