/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.virtualbox;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.VirtualMachineConfig;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.MemoryListener;
import org.glassfish.virtualization.spi.ServerPool;
import org.glassfish.virtualization.spi.StoragePool;
import org.glassfish.virtualization.spi.StorageVol;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.spi.VirtualMachineInfo;
import org.glassfish.virtualization.util.AbstractVirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.glassfish.virtualization.virtualbox.ConnectionManager;
import org.virtualbox_4_1.IConsole;
import org.virtualbox_4_1.IMachine;
import org.virtualbox_4_1.ISession;
import org.virtualbox_4_1.MachineState;
import org.virtualbox_4_1.VirtualBoxManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VBoxVirtualMachine
extends AbstractVirtualMachine {
    private final Machine owner;
    private final String name;
    private InetAddress address;

    protected VBoxVirtualMachine(VirtualMachineConfig config, VirtUser user, Machine owner, String name) throws VirtException {
        super(config, user);
        this.owner = owner;
        this.name = name;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    private IMachine getIMachine(VirtualBoxManager mgr) throws VirtException {
        try {
            return mgr.getVBox().findMachine(this.name);
        }
        catch (Exception e) {
            throw new VirtException((Throwable)e);
        }
    }

    public String executeOn(String[] args) throws IOException, InterruptedException {
        SSHLauncher sshLauncher = new SSHLauncher();
        File home = new File(System.getProperty("user.home"));
        String keyFile = new File(home, ".ssh/id_rsa").getAbsolutePath();
        sshLauncher.init(this.getUser().getName(), this.address.getHostAddress(), 22, null, keyFile, null, Logger.getAnonymousLogger());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder stringBuilder = new StringBuilder();
        for (String arg : args) {
            stringBuilder.append(arg);
            stringBuilder.append(" ");
        }
        sshLauncher.runCommand(stringBuilder.toString().trim(), (OutputStream)baos);
        return baos.toString();
    }

    /*
     * Exception decompiling
     */
    private void execAction(Action action) throws VirtException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void start() throws VirtException {
        this.execAction(Action.START);
    }

    public void stop() throws VirtException {
        this.execAction(Action.STOP);
    }

    public void resume() throws VirtException {
        this.execAction(Action.RESUME);
    }

    public void suspend() throws VirtException {
        this.execAction(Action.SUSPEND);
    }

    public String getName() {
        return this.name;
    }

    public void delete() throws VirtException {
        this.execAction(Action.DELETE);
    }

    public Iterable<StorageVol> volumes() throws VirtException {
        ArrayList<StorageVol> volumes = new ArrayList<StorageVol>();
        for (StoragePool pool : this.owner.getStoragePools().values()) {
            for (StorageVol volume : pool.volumes()) {
                if (!volume.getName().startsWith(this.getName())) continue;
                volumes.add(volume);
            }
        }
        return volumes;
    }

    public VirtualMachineInfo getInfo() {
        return new VirtualMachineInfo(){
            private final Map<MemoryListener, ScheduledFuture> listeners = new HashMap<MemoryListener, ScheduledFuture>();

            public int nbVirtCpu() throws VirtException {
                try {
                    return 1;
                }
                catch (Exception e) {
                    throw new VirtException((Throwable)e);
                }
            }

            public long memory() throws VirtException {
                try {
                    return 30000L;
                }
                catch (Exception e) {
                    throw new VirtException((Throwable)e);
                }
            }

            public long maxMemory() throws VirtException {
                try {
                    return 30000L;
                }
                catch (Exception e) {
                    throw new VirtException((Throwable)e);
                }
            }

            public Machine.State getState() throws VirtException {
                MachineState currentState;
                ISession session;
                VirtualBoxManager connect;
                block14: {
                    connect = null;
                    session = null;
                    connect = ConnectionManager.connection(VBoxVirtualMachine.this.owner.getIpAddress());
                    session = connect.openMachineSession(VBoxVirtualMachine.this.getIMachine(connect));
                    IConsole console = session.getConsole();
                    currentState = console.getState();
                    if (!MachineState.Running.equals((Object)currentState)) break block14;
                    Machine.State state = Machine.State.READY;
                    if (session != null) {
                        connect.closeMachineSession(session);
                    }
                    if (connect != null) {
                        connect.disconnect();
                        connect.cleanup();
                    }
                    return state;
                }
                try {
                    if (MachineState.PoweredOff.equals((Object)currentState)) {
                        Machine.State state = Machine.State.SUSPENDED;
                        if (session != null) {
                            connect.closeMachineSession(session);
                        }
                        if (connect != null) {
                            connect.disconnect();
                            connect.cleanup();
                        }
                        return state;
                    }
                    if (session != null) {
                        connect.closeMachineSession(session);
                    }
                    if (connect != null) {
                        connect.disconnect();
                        connect.cleanup();
                    }
                }
                catch (Exception e) {
                    try {
                        throw new VirtException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            connect.closeMachineSession(session);
                        }
                        if (connect != null) {
                            connect.disconnect();
                            connect.cleanup();
                        }
                        throw throwable;
                    }
                }
                return Machine.State.SUSPENDED;
            }

            public void registerMemoryListener(final MemoryListener ml, long period, TimeUnit unit) {
                ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
                VBoxVirtualMachine owner = VBoxVirtualMachine.this;
                this.listeners.put(ml, executor.schedule(new Runnable((VirtualMachine)owner){
                    final /* synthetic */ VirtualMachine val$owner;
                    {
                        this.val$owner = virtualMachine;
                    }

                    public void run() {
                        try {
                            ml.notified(this.val$owner, this.memory(), this.cpuTime());
                        }
                        catch (VirtException e) {
                            RuntimeContext.logger.log(Level.FINE, "Exception while notifying of vm load ", e);
                        }
                    }
                }, period, unit));
            }

            public void unregisterMemoryListener(MemoryListener ml) {
                this.listeners.get(ml).cancel(false);
            }

            public long cpuTime() throws VirtException {
                return 3L;
            }
        };
    }

    public ServerPool getServerPool() {
        return this.owner.getServerPool();
    }

    public Machine getMachine() {
        return this.owner;
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$glassfish$virtualization$virtualbox$VBoxVirtualMachine$Action;

        static {
            $SwitchMap$org$glassfish$virtualization$virtualbox$VBoxVirtualMachine$Action = new int[Action.values().length];
            try {
                2.$SwitchMap$org$glassfish$virtualization$virtualbox$VBoxVirtualMachine$Action[Action.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$glassfish$virtualization$virtualbox$VBoxVirtualMachine$Action[Action.STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$glassfish$virtualization$virtualbox$VBoxVirtualMachine$Action[Action.RESUME.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$glassfish$virtualization$virtualbox$VBoxVirtualMachine$Action[Action.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$glassfish$virtualization$virtualbox$VBoxVirtualMachine$Action[Action.SUSPEND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        START,
        STOP,
        RESUME,
        DELETE,
        SUSPEND;

    }
}

