/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_4_1;

import java.util.List;
import org.virtualbox_4_1.Helper;
import org.virtualbox_4_1.Holder;
import org.virtualbox_4_1.HostNetworkInterfaceType;
import org.virtualbox_4_1.IHostNetworkInterface;
import org.virtualbox_4_1.IHostUSBDevice;
import org.virtualbox_4_1.IHostUSBDeviceFilter;
import org.virtualbox_4_1.IMedium;
import org.virtualbox_4_1.IProgress;
import org.virtualbox_4_1.IUnknown;
import org.virtualbox_4_1.VBoxException;
import org.virtualbox_4_1.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_4_1.jaxws.ProcessorFeature;
import org.virtualbox_4_1.jaxws.RuntimeFaultMsg;
import org.virtualbox_4_1.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IHost
extends IUnknown {
    public IHost(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public List<IMedium> getDVDDrives() {
        try {
            List<String> list = this.port.iHostGetDVDDrives(this.obj);
            return Helper.wrap(IMedium.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IMedium> getFloppyDrives() {
        try {
            List<String> list = this.port.iHostGetFloppyDrives(this.obj);
            return Helper.wrap(IMedium.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IHostUSBDevice> getUSBDevices() {
        try {
            List<String> list = this.port.iHostGetUSBDevices(this.obj);
            return Helper.wrap(IHostUSBDevice.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IHostUSBDeviceFilter> getUSBDeviceFilters() {
        try {
            List<String> list = this.port.iHostGetUSBDeviceFilters(this.obj);
            return Helper.wrap(IHostUSBDeviceFilter.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IHostNetworkInterface> getNetworkInterfaces() {
        try {
            List<String> list = this.port.iHostGetNetworkInterfaces(this.obj);
            return Helper.wrap(IHostNetworkInterface.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Long getProcessorCount() {
        try {
            Long l = this.port.iHostGetProcessorCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Long getProcessorOnlineCount() {
        try {
            Long l = this.port.iHostGetProcessorOnlineCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Long getProcessorCoreCount() {
        try {
            Long l = this.port.iHostGetProcessorCoreCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Long getMemorySize() {
        try {
            Long l = this.port.iHostGetMemorySize(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Long getMemoryAvailable() {
        try {
            Long l = this.port.iHostGetMemoryAvailable(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getOperatingSystem() {
        try {
            String string = this.port.iHostGetOperatingSystem(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getOSVersion() {
        try {
            String string = this.port.iHostGetOSVersion(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Long getUTCTime() {
        try {
            Long l = this.port.iHostGetUTCTime(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Boolean getAcceleration3DAvailable() {
        try {
            Boolean bl = this.port.iHostGetAcceleration3DAvailable(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public static IHost queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IHost(iUnknown.getWrapped(), iUnknown.getRemoteWSPort());
    }

    public Long getProcessorSpeed(Long l) {
        try {
            Long l2 = this.port.iHostGetProcessorSpeed(this.obj, l);
            return l2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Boolean getProcessorFeature(org.virtualbox_4_1.ProcessorFeature processorFeature) {
        try {
            Boolean bl = this.port.iHostGetProcessorFeature(this.obj, ProcessorFeature.fromValue(processorFeature.name()));
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String getProcessorDescription(Long l) {
        try {
            String string = this.port.iHostGetProcessorDescription(this.obj, l);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void getProcessorCPUIDLeaf(Long l, Long l2, Long l3, Holder<Long> holder, Holder<Long> holder2, Holder<Long> holder3, Holder<Long> holder4) {
        try {
            javax.xml.ws.Holder holder5 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder6 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder7 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder8 = new javax.xml.ws.Holder();
            this.port.iHostGetProcessorCPUIDLeaf(this.obj, l, l2, l3, (javax.xml.ws.Holder<Long>)holder5, (javax.xml.ws.Holder<Long>)holder6, (javax.xml.ws.Holder<Long>)holder7, (javax.xml.ws.Holder<Long>)holder8);
            holder.value = holder5.value;
            holder2.value = holder6.value;
            holder3.value = holder7.value;
            holder4.value = holder8.value;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IProgress createHostOnlyNetworkInterface(Holder<IHostNetworkInterface> holder) {
        try {
            javax.xml.ws.Holder holder2 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder3 = new javax.xml.ws.Holder();
            this.port.iHostCreateHostOnlyNetworkInterface(this.obj, (javax.xml.ws.Holder<String>)holder2, (javax.xml.ws.Holder<String>)holder3);
            holder.value = ((String)holder2.value).length() > 0 ? new IHostNetworkInterface((String)holder2.value, this.port) : null;
            return ((String)holder3.value).length() > 0 ? new IProgress((String)holder3.value, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IProgress removeHostOnlyNetworkInterface(String string) {
        try {
            String string2 = this.port.iHostRemoveHostOnlyNetworkInterface(this.obj, string);
            return string2.length() > 0 ? new IProgress(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IHostUSBDeviceFilter createUSBDeviceFilter(String string) {
        try {
            String string2 = this.port.iHostCreateUSBDeviceFilter(this.obj, string);
            return string2.length() > 0 ? new IHostUSBDeviceFilter(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void insertUSBDeviceFilter(Long l, IHostUSBDeviceFilter iHostUSBDeviceFilter) {
        try {
            this.port.iHostInsertUSBDeviceFilter(this.obj, l, iHostUSBDeviceFilter == null ? null : iHostUSBDeviceFilter.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void removeUSBDeviceFilter(Long l) {
        try {
            this.port.iHostRemoveUSBDeviceFilter(this.obj, l);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IMedium findHostDVDDrive(String string) {
        try {
            String string2 = this.port.iHostFindHostDVDDrive(this.obj, string);
            return string2.length() > 0 ? new IMedium(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IMedium findHostFloppyDrive(String string) {
        try {
            String string2 = this.port.iHostFindHostFloppyDrive(this.obj, string);
            return string2.length() > 0 ? new IMedium(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IHostNetworkInterface findHostNetworkInterfaceByName(String string) {
        try {
            String string2 = this.port.iHostFindHostNetworkInterfaceByName(this.obj, string);
            return string2.length() > 0 ? new IHostNetworkInterface(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IHostNetworkInterface findHostNetworkInterfaceById(String string) {
        try {
            String string2 = this.port.iHostFindHostNetworkInterfaceById(this.obj, string);
            return string2.length() > 0 ? new IHostNetworkInterface(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IHostNetworkInterface> findHostNetworkInterfacesOfType(HostNetworkInterfaceType hostNetworkInterfaceType) {
        try {
            List<String> list = this.port.iHostFindHostNetworkInterfacesOfType(this.obj, org.virtualbox_4_1.jaxws.HostNetworkInterfaceType.fromValue(hostNetworkInterfaceType.name()));
            return Helper.wrap(IHostNetworkInterface.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IHostUSBDevice findUSBDeviceById(String string) {
        try {
            String string2 = this.port.iHostFindUSBDeviceById(this.obj, string);
            return string2.length() > 0 ? new IHostUSBDevice(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IHostUSBDevice findUSBDeviceByAddress(String string) {
        try {
            String string2 = this.port.iHostFindUSBDeviceByAddress(this.obj, string);
            return string2.length() > 0 ? new IHostUSBDevice(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public String generateMACAddress() {
        try {
            String string = this.port.iHostGenerateMACAddress(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }
}

