/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.connector.annotation.handlers;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateless;
import jakarta.jws.HandlerChain;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;
import org.glassfish.webservices.connector.LogUtils;
import org.glassfish.webservices.connector.annotation.handlers.HandlerChainHandler;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=WebService.class)
public class WebServiceHandler
extends AbstractHandler {
    private static final Logger conLogger = LogUtils.getLogger();
    private static final LocalStringManagerImpl wsLocalStrings = new LocalStringManagerImpl(WebServiceHandler.class);

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        AnnotationProcessorException ape;
        com.sun.enterprise.deployment.WebService newWS;
        WebServiceEndpoint endpoint;
        WebServiceEndpoint wep;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        Class<?> origAnnElem = annElem;
        boolean ejbInWar = this.ignoreWebserviceAnnotations(annElem, annCtx);
        if (ejbInWar) {
            return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        if (!(annElem instanceof Class)) {
            AnnotationProcessorException ape2 = new AnnotationProcessorException(wsLocalStrings.getLocalString("enterprise.deployment.annotation.handlers.wrongannotationlocation", "WS00022: symbol annotation can only be specified on TYPE"), annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape2);
            return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.FAILED);
        }
        if (((Class)annElem).isInterface()) {
            return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        if (this.isJaxwsRIDeployment(annInfo)) {
            conLogger.log(Level.INFO, "AS-WSCONNECTOR-00057", new Object[]{annInfo.getProcessingContext().getArchive().getName(), "WEB-INF/sun-jaxws.xml"});
            return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        WebService ann = (WebService)annInfo.getAnnotation();
        WebBundleDescriptor bundleDesc = null;
        try {
            if (this.ejbProvider != null && this.ejbProvider.getType("jakarta.ejb.Stateless") != null) {
                if (annCtx instanceof EjbContext) {
                    EjbContext ctx = (EjbContext)annCtx;
                    bundleDesc = ctx.getDescriptor().getEjbBundleDescriptor();
                    bundleDesc.setSpecVersion("3.0");
                } else if (annCtx instanceof EjbsContext) {
                    String name = this.getEjbName(annElem);
                    for (EjbContext ejbCtx : ((EjbsContext)annCtx).getEjbContexts()) {
                        EjbDescriptor descriptor = ejbCtx.getDescriptor();
                        if (!name.equals(descriptor.getName())) continue;
                        bundleDesc = descriptor.getEjbBundleDescriptor();
                        bundleDesc.setSpecVersion("3.0");
                        break;
                    }
                }
            }
            if (bundleDesc == null) {
                if (annCtx instanceof WebComponentContext) {
                    bundleDesc = ((WebComponentContext)annCtx).getDescriptor().getWebBundleDescriptor();
                } else if (!(annCtx instanceof WebBundleContext)) {
                    return this.getInvalidAnnotatedElementHandlerResult(annInfo.getProcessingContext().getHandler(), annInfo);
                }
                bundleDesc = ((WebBundleContext)annCtx).getDescriptor();
                bundleDesc.setSpecVersion("2.5");
            }
        }
        catch (Exception e) {
            throw new AnnotationProcessorException(wsLocalStrings.getLocalString("webservice.annotation.exception", "WS00023: Exception in processing @Webservice : {0}", new Object[]{e.getMessage()}));
        }
        String portComponentName = ann.name();
        String svcNameFromImplClass = ann.serviceName();
        String implClassName = ((Class)annElem).getSimpleName();
        String implClassFullName = ((Class)annElem).getName();
        String targetNameSpace = ann.targetNamespace();
        String portNameFromImplClass = ann.portName();
        if (portNameFromImplClass == null || portNameFromImplClass.length() == 0) {
            portNameFromImplClass = portComponentName != null && portComponentName.length() != 0 ? portComponentName + "Port" : implClassName + "Port";
        }
        String userSpecifiedBinding = null;
        BindingType bindingAnn = ((Class)annElem).getAnnotation(BindingType.class);
        if (bindingAnn != null) {
            userSpecifiedBinding = bindingAnn.value();
        }
        String wsdlLocation = null;
        if (ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
            wsdlLocation = ann.wsdlLocation();
        }
        if (ann.endpointInterface() != null && ann.endpointInterface().length() > 0) {
            Class<?> endpointIntf;
            try {
                endpointIntf = ((Class)annElem).getClassLoader().loadClass(ann.endpointInterface());
            }
            catch (ClassNotFoundException cfne) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.classnotfound", "class {0} referenced from annotation symbol cannot be loaded", new Object[]{ann.endpointInterface()}), annInfo);
            }
            annElem = endpointIntf;
            ann = annElem.getAnnotation(WebService.class);
            if (ann == null) {
                throw new AnnotationProcessorException(wsLocalStrings.getLocalString("no.webservice.annotation", "WS00025: SEI {0} referenced from the @WebService annotation on {1}  does not contain a @WebService annotation", new Object[]{((WebService)annInfo.getAnnotation()).endpointInterface(), ((Class)annElem).getName()}));
            }
            if (annElem.getAnnotation(BindingType.class) != null) {
                throw new AnnotationProcessorException(wsLocalStrings.getLocalString("cannot.have.bindingtype", "WS00026: SEI {0} cannot have @BindingType", new Object[]{((WebService)annInfo.getAnnotation()).endpointInterface()}));
            }
        }
        WebServicesDescriptor wsDesc = bundleDesc.getWebServices();
        if (portComponentName == null || portComponentName.length() == 0) {
            portComponentName = implClassName;
        }
        if ((wep = wsDesc.getEndpointByName(portComponentName)) != null && wep.getServiceEndpointInterface() != null && wep.getServiceEndpointInterface().length() != 0 && !((Class)annElem).getName().equals(wep.getServiceEndpointInterface())) {
            portComponentName = implClassFullName;
        }
        if ((endpoint = wsDesc.getEndpointByName(portComponentName)) == null) {
            if (DOLUtils.warType().equals((Object)bundleDesc.getModuleType())) {
                WebComponentDescriptor[] wcByImplName;
                for (WebComponentDescriptor wc : wcByImplName = bundleDesc.getWebComponentByImplName(implClassFullName)) {
                    if (wsDesc.getEndpointsImplementedBy(wc).isEmpty()) continue;
                    this.logger.log(Level.SEVERE, "AS-WSCONNECTOR-00205", new Object[]{implClassFullName});
                    break;
                }
            }
            if ((newWS = svcNameFromImplClass != null && svcNameFromImplClass.length() != 0 ? wsDesc.getWebServiceByName(svcNameFromImplClass) : wsDesc.getWebServiceByName(implClassName + "Service")) == null) {
                newWS = new com.sun.enterprise.deployment.WebService();
                if (svcNameFromImplClass != null && svcNameFromImplClass.length() != 0) {
                    newWS.setName(svcNameFromImplClass);
                } else {
                    newWS.setName(implClassName + "Service");
                }
                wsDesc.addWebService(newWS);
            }
            endpoint = new WebServiceEndpoint();
            if (portComponentName != null && portComponentName.length() != 0) {
                endpoint.setEndpointName(portComponentName);
            } else {
                endpoint.setEndpointName(((Class)annElem).getName());
            }
            newWS.addEndpoint(endpoint);
            wsDesc.setSpecVersion("1.3");
        } else {
            newWS = endpoint.getWebService();
        }
        if (endpoint.getWsdlService() != null) {
            if (targetNameSpace != null && targetNameSpace.length() != 0 && !endpoint.getWsdlService().getNamespaceURI().equals(targetNameSpace)) {
                ape = new AnnotationProcessorException(wsLocalStrings.getLocalString("mismatch.targetnamespace", "WS00027: Target Namespace in wsdl-service element does not match @WebService.targetNamespace"), annInfo);
                annInfo.getProcessingContext().getErrorHandler().error(ape);
                return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.FAILED);
            }
            targetNameSpace = endpoint.getWsdlService().getNamespaceURI();
        }
        if (endpoint.getWsdlService() != null && endpoint.getWsdlPort() != null && !endpoint.getWsdlService().getNamespaceURI().equals(endpoint.getWsdlPort().getNamespaceURI())) {
            ape = new AnnotationProcessorException(wsLocalStrings.getLocalString("mismatch.port.targetnamespace", "WS00028: Target Namespace for wsdl-service and wsdl-port should be the same"), annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.FAILED);
        }
        if (newWS.getWsdlFileUri() == null) {
            if (wsdlLocation != null) {
                newWS.setWsdlFileUri(wsdlLocation);
            } else if (ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
                newWS.setWsdlFileUri(ann.wsdlLocation());
            }
        }
        if (!endpoint.hasUserSpecifiedProtocolBinding() && userSpecifiedBinding != null && userSpecifiedBinding.length() != 0) {
            endpoint.setProtocolBinding(userSpecifiedBinding);
        }
        if (endpoint.getServiceEndpointInterface() == null) {
            if (ann.endpointInterface() != null && ann.endpointInterface().length() != 0) {
                endpoint.setServiceEndpointInterface(ann.endpointInterface());
            } else {
                endpoint.setServiceEndpointInterface(((Class)annElem).getName());
            }
        }
        annElem = annInfo.getAnnotatedElement();
        if (DOLUtils.warType().equals((Object)bundleDesc.getModuleType())) {
            if (endpoint.getServletImplClass() == null) {
                endpoint.setServletImplClass(((Class)annElem).getName());
            }
            WebBundleDescriptor webBundle = bundleDesc;
            if (endpoint.getWebComponentLink() == null) {
                endpoint.setWebComponentLink(implClassFullName);
            }
            if (endpoint.getWebComponentImpl() == null) {
                WebComponentDescriptor[] wcs;
                WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(endpoint.getWebComponentLink());
                if (webComponent == null && (wcs = webBundle.getWebComponentByImplName(implClassFullName)).length > 0) {
                    webComponent = wcs[0];
                }
                if (webComponent == null) {
                    webComponent = new WebComponentDescriptorImpl();
                    webComponent.setServlet(true);
                    webComponent.setWebComponentImplementation(((Class)annElem).getCanonicalName());
                    webComponent.setName(endpoint.getEndpointName());
                    webComponent.addUrlPattern("/" + newWS.getName());
                    webBundle.addWebComponentDescriptor(webComponent);
                }
                endpoint.setWebComponentImpl(webComponent);
            }
        } else {
            String name = this.getEjbName(annElem);
            EjbDescriptor ejb = ((EjbBundleDescriptor)bundleDesc).getEjbByName(name);
            endpoint.setEjbComponentImpl(ejb);
            ejb.setWebServiceEndpointInterfaceName(endpoint.getServiceEndpointInterface());
            if (endpoint.getEjbLink() == null) {
                endpoint.setEjbLink(ejb.getName());
            }
        }
        if (endpoint.getWsdlPort() == null) {
            if (targetNameSpace == null || targetNameSpace.length() == 0) {
                if (((Class)annElem).getPackage() != null) {
                    StringTokenizer tokens = new StringTokenizer(((Class)annElem).getPackage().getName(), ".", false);
                    if (tokens.hasMoreElements()) {
                        while (tokens.hasMoreElements()) {
                            if (targetNameSpace == null || targetNameSpace.length() == 0) {
                                targetNameSpace = tokens.nextElement().toString();
                                continue;
                            }
                            targetNameSpace = tokens.nextElement().toString() + "." + targetNameSpace;
                        }
                    } else {
                        targetNameSpace = ((Class)annElem).getPackage().getName();
                    }
                } else {
                    throw new AnnotationProcessorException(wsLocalStrings.getLocalString("missing.targetnamespace", "WS00029: The jakarta.jws.WebService annotation targetNamespace must be used for classes or interfaces that are in no package"));
                }
                targetNameSpace = "http://" + (targetNameSpace == null ? "" : targetNameSpace + "/");
            }
            endpoint.setWsdlPort(new QName(targetNameSpace, portNameFromImplClass, "ns1"));
        }
        if (endpoint.getWsdlService() == null) {
            String serviceNameSpace = endpoint.getWsdlPort().getNamespaceURI();
            String serviceName = null;
            serviceName = svcNameFromImplClass != null && svcNameFromImplClass.length() != 0 ? svcNameFromImplClass : newWS.getName();
            endpoint.setWsdlService(new QName(serviceNameSpace, serviceName, "ns1"));
        }
        if (origAnnElem.getAnnotation(HandlerChain.class) == null) {
            return new HandlerChainHandler().processHandlerChainAnnotation(annInfo, annCtx, origAnnElem, origAnnElem, true);
        }
        return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    private boolean ignoreWebserviceAnnotations(AnnotatedElement annElem, AnnotatedElementHandler annCtx) {
        Stateless stateless = annElem.getAnnotation(Stateless.class);
        WebService webservice = annElem.getAnnotation(WebService.class);
        return stateless != null && webservice != null && (annCtx instanceof WebBundleContext || annCtx instanceof WebComponentContext);
    }

    private boolean isJaxwsRIDeployment(AnnotationInfo annInfo) {
        boolean riDeployment = false;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        try {
            ReadableArchive moduleArchive = annInfo.getProcessingContext().getArchive();
            if (moduleArchive != null && moduleArchive.exists("WEB-INF/sun-jaxws.xml") && !((Class)annInfo.getAnnotatedElement()).isInterface() && (annCtx instanceof WebBundleContext || annCtx instanceof WebComponentContext)) {
                riDeployment = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return riDeployment;
    }

    private String getEjbName(AnnotatedElement annElem) {
        Singleton singleton;
        Stateless stateless;
        block5: {
            block4: {
                stateless = null;
                try {
                    stateless = annElem.getAnnotation(Stateless.class);
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(Level.FINE)) break block4;
                    conLogger.log(Level.FINE, "AS-WSCONNECTOR-00050", e);
                }
            }
            singleton = null;
            try {
                singleton = annElem.getAnnotation(Singleton.class);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.FINE)) break block5;
                conLogger.log(Level.FINE, "AS-WSCONNECTOR-00050", e);
            }
        }
        String name = stateless != null && (stateless.name() == null || stateless.name().length() > 0) ? stateless.name() : (singleton != null && (singleton.name() == null || singleton.name().length() > 0) ? singleton.name() : ((Class)annElem).getSimpleName());
        return name;
    }
}

