/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.embed.GFApplication;
import org.glassfish.embed.GlassFish;
import org.glassfish.embed.ScatteredWar;

public class RunMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File resourcesDirectory;
    protected File webXml;
    protected int httpPort = 8080;

    public void execute() throws MojoExecutionException, MojoFailureException {
        GlassFish glassfish = new GlassFish(this.httpPort);
        ArrayList<URL> classpath = new ArrayList<URL>();
        try {
            for (Artifact a : this.project.getArtifacts()) {
                classpath.add(a.getFile().toURI().toURL());
            }
            for (Resource res : this.project.getBuild().getResources()) {
                classpath.add(new File(res.getDirectory()).toURI().toURL());
            }
            classpath.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to convert to URL", (Exception)e);
        }
        ScatteredWar war = new ScatteredWar(this.project.getArtifactId(), this.resourcesDirectory, this.webXml, classpath);
        try {
            while (true) {
                GFApplication app = glassfish.deploy((ReadableArchive)war);
                System.out.println("Hit ENTER for redeploy");
                new BufferedReader(new InputStreamReader(System.in)).readLine();
                app.undeploy();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

