/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.javase;

import bsh.EvalError;
import com.sun.istack.NotNull;
import com.sun.xml.ws.test.CodeGenerator;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.client.InterpreterEx;
import com.sun.xml.ws.test.container.AbstractApplicationContainer;
import com.sun.xml.ws.test.container.Application;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.container.javase.JavaSeApplication;
import com.sun.xml.ws.test.container.jelly.EndpointInfoBean;
import com.sun.xml.ws.test.model.TestEndpoint;
import com.sun.xml.ws.test.tool.WsTool;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class JavaSeContainer
extends AbstractApplicationContainer {
    private final Set<String> unsupportedUses;

    public JavaSeContainer(WsTool wsimport, WsTool wsgen, int port, Set<String> unsupportedUses) {
        super(wsimport, wsgen, false);
        this.unsupportedUses = unsupportedUses;
    }

    @Override
    @NotNull
    public Set<String> getUnsupportedUses() {
        return this.unsupportedUses;
    }

    @Override
    public String getTransport() {
        return "http";
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void shutdown() {
    }

    @Override
    @NotNull
    public Application deploy(DeployedService service) throws Exception {
        String id = service.service.getGlobalUniqueName();
        WAR war = this.assembleWar(service);
        List<EndpointInfoBean> beans = war.getEndpointsInfos();
        URL baseAddress = new URL("http://localhost:" + JavaSeContainer.getFreePort() + "/" + id + "/");
        URLClassLoader serviceClassLoader = new URLClassLoader(new URL[]{service.warDir.toURL(), new File(service.warDir, "WEB-INF/classes").toURL()}, World.runtime.getClassLoader());
        Object[] servers = new Object[service.service.endpoints.size()];
        int i = 0;
        for (TestEndpoint testEndpoint : service.service.endpoints) {
            Annotation[] anns;
            InterpreterEx interpreter = new InterpreterEx(serviceClassLoader);
            Annotation[] endpointInfoBean = null;
            for (Object bean : beans.toArray()) {
                Annotation[] ebean = (Annotation[])bean;
                if (!ebean.getImplementation().equals(testEndpoint.className)) continue;
                endpointInfoBean = ebean;
                break;
            }
            if (service.service.isSTS) {
                this.updateWsitClient(war, service, baseAddress + testEndpoint.name);
            }
            Class<?> endpointClass = serviceClassLoader.loadClass(testEndpoint.className);
            Object endpointImpl = endpointClass.newInstance();
            String wsdlLocation = null;
            for (Annotation ann : anns = endpointClass.getAnnotations()) {
                try {
                    Method method = ann.getClass().getDeclaredMethod("wsdlLocation", new Class[0]);
                    String str = (String)method.invoke((Object)ann, new Object[0]);
                    if (str.equals("")) continue;
                    wsdlLocation = str;
                    break;
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
            }
            ArrayList<Source> metadata = new ArrayList<Source>();
            this.collectDocs(service.warDir.getCanonicalPath() + "/", "WEB-INF/wsdl/", serviceClassLoader, metadata);
            if (wsdlLocation != null) {
                Iterator it = metadata.iterator();
                while (it.hasNext()) {
                    Source source = (Source)it.next();
                    if (!source.getSystemId().endsWith(wsdlLocation)) continue;
                    it.remove();
                }
            }
            System.out.print("Setting metadata=" + metadata);
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (endpointInfoBean != null && endpointInfoBean.getServiceName() != null) {
                props.put("javax.xml.ws.wsdl.service", endpointInfoBean.getServiceName());
            }
            if (endpointInfoBean != null && endpointInfoBean.getPortName() != null) {
                props.put("javax.xml.ws.wsdl.port", endpointInfoBean.getPortName());
            }
            System.out.println("Setting properties=" + props);
            String endpointAddress = baseAddress + testEndpoint.name;
            System.out.println("Endpoint Address=" + endpointAddress);
            interpreter.set("endpointAddress", endpointAddress);
            interpreter.set("endpointImpl", endpointImpl);
            interpreter.set("metadata", metadata);
            interpreter.set("properties", props);
            Object feature = this.createMetadataFeature(service, interpreter);
            interpreter.set("feature", feature);
            CodeGenerator.generateDeploySources(war, testEndpoint, metadata, props, endpointAddress, wsdlLocation, !service.service.wsdl.isEmpty());
            try {
                String statements = "      javax.xml.ws.Endpoint endpoint = javax.xml.ws.Endpoint.create(endpointImpl" + (feature != null ? ", new javax.xml.ws.WebServiceFeature[] {feature});" : ");\n") + "      endpoint.setMetadata(metadata);\n      endpoint.setProperties(properties);\n      endpoint.publish(\"" + endpointAddress + "\");\n      return endpoint;\n";
                servers[i++] = interpreter.eval(statements);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new Exception("Deploying endpoint " + endpointAddress + " failed", t);
            }
        }
        return new JavaSeApplication(servers, baseAddress, service);
    }

    private Object createMetadataFeature(DeployedService service, InterpreterEx interpreter) throws EvalError {
        if (service.service.parent.metadatafiles == null || service.service.parent.metadatafiles.isEmpty()) {
            return null;
        }
        String script = "com.oracle.webservices.api.databinding.ExternalMetadataFeature.builder().addFiles( metadataFiles ).build()";
        File[] files = new File[service.service.parent.metadatafiles.size()];
        int i = 0;
        for (String path : service.service.parent.metadatafiles) {
            files[i++] = new File(service.service.baseDir + File.separator + path);
        }
        interpreter.set("metadataFiles", files);
        return interpreter.eval(script);
    }

    private Set<String> getResourcePaths(String root, String path) {
        HashSet<String> r = new HashSet<String>();
        File[] files = new File(root + path).listFiles();
        if (files == null) {
            return null;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                r.add(path + f.getName() + '/');
                continue;
            }
            r.add(path + f.getName());
        }
        return r;
    }

    private static int getFreePort() {
        if (CodeGenerator.isGenerateTestSources()) {
            return CodeGenerator.getFreePort();
        }
        int port = -1;
        try {
            ServerSocket soc = new ServerSocket(0);
            port = soc.getLocalPort();
            soc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return port;
    }

    private void collectDocs(String root, String dirPath, ClassLoader loader, List<Source> metadata) throws IOException {
        Set<String> paths = this.getResourcePaths(root, dirPath);
        if (paths != null) {
            for (String path : paths) {
                if (path.endsWith("/")) {
                    if (path.endsWith("/CVS/") || path.endsWith("/.svn/")) continue;
                    this.collectDocs(root, path, loader, metadata);
                    continue;
                }
                URL res = loader.getResource(path);
                metadata.add(new StreamSource(res.openStream(), res.toExternalForm()));
            }
        }
    }
}

