/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.local;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.container.Application;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.model.TestEndpoint;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

final class LocalApplication
implements Application {
    @NotNull
    private final WAR war;
    @NotNull
    private final URI baseEndpointAddress;

    LocalApplication(@NotNull WAR war, URI endpointAddress) {
        this.war = war;
        this.baseEndpointAddress = endpointAddress;
    }

    @Override
    @NotNull
    public URI getEndpointAddress(@NotNull TestEndpoint endpoint) throws Exception {
        return new URI(this.baseEndpointAddress.toString() + '?' + endpoint.name);
    }

    @Override
    @NotNull
    public List<URL> getWSDL() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File w : this.war.getWSDL()) {
            urls.add(w.toURL());
        }
        return urls;
    }

    @Override
    public void undeploy() throws Exception {
    }
}

