/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.local;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.container.AbstractApplicationContainer;
import com.sun.xml.ws.test.container.Application;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.container.local.LocalApplication;
import com.sun.xml.ws.test.tool.WsTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class LocalApplicationContainer
extends AbstractApplicationContainer {
    public LocalApplicationContainer(WsTool wsimport, WsTool wsgen) {
        super(wsimport, wsgen, false);
    }

    @Override
    public String getTransport() {
        return "local";
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    @NotNull
    public Application deploy(DeployedService service) throws Exception {
        WAR war = this.assembleWar(service);
        if (service.service.isSTS) {
            String newLocation = "local://" + service.warDir.getAbsolutePath() + "/";
            newLocation = newLocation.replace('\\', '/');
            this.updateWsitClient(war, service, newLocation);
        }
        for (File wsdl : war.getWSDL()) {
            this.patchWsdl(service, wsdl);
        }
        return new LocalApplication(war, new URI("local://" + service.warDir.getAbsolutePath().replace('\\', '/')));
    }

    private void patchWsdl(DeployedService service, File wsdl) throws Exception {
        Document doc = new SAXReader().read(wsdl);
        List ports = doc.getRootElement().element("service").elements("port");
        for (Element port : ports) {
            String portName = port.attributeValue("name");
            Element address = (Element)port.elements().get(0);
            Attribute locationAttr = address.attribute("location");
            String newLocation = "local://" + service.warDir.getAbsolutePath() + "?" + portName;
            newLocation = newLocation.replace('\\', '/');
            locationAttr.setValue(newLocation);
            Element wsaEprEl = port.element(QName.get((String)"EndpointReference", (String)"wsa", (String)"http://www.w3.org/2005/08/addressing"));
            if (wsaEprEl == null) continue;
            Element wsaAddrEl = wsaEprEl.element(QName.get((String)"Address", (String)"wsa", (String)"http://www.w3.org/2005/08/addressing"));
            wsaAddrEl.setText(newLocation);
        }
        FileOutputStream os = new FileOutputStream(wsdl);
        new XMLWriter((OutputStream)os).write(doc);
        os.close();
    }
}

