/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.model;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;

public abstract class Script {
    private Script() {
    }

    public abstract String getName();

    public abstract Reader read() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSource() {
        Reader reader = null;
        try {
            int read;
            reader = this.read();
            StringWriter writer = new StringWriter();
            char[] buf = new char[1024];
            while ((read = reader.read(buf)) != -1) {
                writer.write(buf, 0, read);
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = "<ERROR READING SCRIPT>";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final class File
    extends Script {
        private final java.io.File script;

        public File(java.io.File script) {
            this.script = script;
        }

        @Override
        public String getName() {
            return this.script.getName();
        }

        @Override
        public Reader read() throws IOException {
            return new InputStreamReader((InputStream)new FileInputStream(this.script), "UTF-8");
        }
    }

    public static final class Inline
    extends Script {
        private final String name;
        private final String script;

        public Inline(String name, String script) {
            this.name = name;
            this.script = script;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Reader read() {
            return new StringReader(this.script);
        }
    }
}

