/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.tool;

import com.sun.xml.ws.test.CodeGenerator;
import com.sun.xml.ws.test.tool.LocalWsTool;
import com.sun.xml.ws.test.tool.RemoteWsTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;

public abstract class WsTool
extends Assert {
    private boolean dumpParameters;
    public static WsTool NOOP = new WsTool(false){

        @Override
        public void invoke(String ... args) {
        }
    };

    protected WsTool(boolean dumpParameters) {
        this.dumpParameters = dumpParameters;
    }

    public abstract void invoke(String ... var1) throws Exception;

    public boolean isNoop() {
        return this == NOOP;
    }

    public static WsTool createWsImport(File externalWsImport, boolean dumpParameters, String extraWsToolsArgs) {
        return WsTool.createTool(externalWsImport, "com.sun.tools.ws.WsImport", dumpParameters, extraWsToolsArgs);
    }

    public static WsTool createWsGen(File externalWsGen, boolean dumpParameters, String extraWsToolsArgs) {
        return WsTool.createTool(externalWsGen, "com.sun.tools.ws.WsGen", dumpParameters, extraWsToolsArgs);
    }

    private static WsTool createTool(File externalExecutable, String className, boolean dumpParameters, String extraWsToolsArgs) {
        if (externalExecutable != null) {
            return new RemoteWsTool(externalExecutable, dumpParameters, extraWsToolsArgs);
        }
        return new LocalWsTool(className, dumpParameters);
    }

    protected void dumpWsParams(List<String> params) {
        System.err.println("\n\nINVOKING WS Tool:\n");
        for (int i = 0; i < params.size(); ++i) {
            System.err.print(i == 0 ? " " : "     ");
            System.err.print(params.get(i));
            System.err.println(i + 1 < params.size() ? " \\" : "\n");
        }
        if (CodeGenerator.isGenerateTestSources()) {
            ArrayList<String> mkdirs = new ArrayList<String>();
            ArrayList<String> params2 = new ArrayList<String>();
            for (int i = 0; i < params.size(); ++i) {
                String p = params.get(i);
                if (i == 0) {
                    int index = p.lastIndexOf("/");
                    if (++index > 0 && index < p.length()) {
                        p = p.substring(index);
                    }
                }
                if ("-s".equals(p.trim()) || "-d".equals(p.trim()) || "-r".equals(p.trim())) {
                    String dir = params.get(i + 1);
                    mkdirs.add(dir);
                }
                p = CodeGenerator.fixedURLBASH(p);
                if (!(p = CodeGenerator.toRelativePath(p)).startsWith("http://")) {
                    p = p.replaceAll("\\$", "\\\\\\$");
                }
                if (p.startsWith("../") && !p.startsWith("../src")) {
                    p = p.replaceAll("\\.\\./", "../src/");
                }
                params2.add(p.replaceAll("localhost", "127.0.0.1"));
            }
            CodeGenerator.generateTool(mkdirs, params2);
        }
    }

    protected boolean dumpParams() {
        return this.dumpParameters || CodeGenerator.isGenerateTestSources();
    }
}

