/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SourcesCollector {
    private static final Set IGNORED = new HashSet();
    String source;

    public SourcesCollector(String source) {
        this.source = source;
    }

    public static void ensureDirectoryExists(String newDir) {
        File file = new File(newDir);
        if (!file.exists()) {
            SourcesCollector.ensureDirectoryExists(file.getParent());
            file.mkdir();
        }
    }

    public void copyFilesTo(String destDir) {
        List<String> files = this.collectFiles();
        for (String file : files) {
            File src = new File(this.source + "/" + file);
            File dst = new File(destDir + "/" + file);
            SourcesCollector.ensureDirectoryExists(dst.getParent());
            try {
                SourcesCollector.copy(src, dst);
            }
            catch (IOException e) {
                System.err.println("Error copying file: [" + String.valueOf(src) + "] to [" + String.valueOf(dst) + "]");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File dest) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            System.out.println("copy [" + String.valueOf(source.getAbsoluteFile()) + "]\n  to [" + String.valueOf(dest.getAbsoluteFile()) + "].");
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            int totalLength = 0;
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
                totalLength += length;
            }
            System.out.println("totalLength = " + totalLength);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    protected List<String> collectFiles() {
        File f = new File(this.source);
        File[] files = f.listFiles();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            this.collectFile(file, result);
        }
        return result;
    }

    private void collectFile(File file, List<String> files) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.collectFile(f, files);
            }
        } else {
            String result = file.getAbsoluteFile().toString().replaceAll(this.source, "");
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            if (!IGNORED.contains(result)) {
                System.out.println("file: [" + result + "]");
                files.add(result);
            }
        }
    }

    static {
        IGNORED.add(".DS_Store");
    }
}

