/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.cargo;

import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.container.cargo.AbstractRunnableCargoContainer;
import com.sun.xml.ws.test.tool.WsTool;
import com.sun.xml.ws.test.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;

public class InstalledCargoApplicationContainer
extends AbstractRunnableCargoContainer<InstalledLocalContainer> {
    public InstalledCargoApplicationContainer(WsTool wsimport, WsTool wsgen, String containerId, File homeDir, int port, boolean httpspi) throws IOException {
        super(wsimport, wsgen, port, httpspi);
        DefaultConfigurationFactory configurationFactory = new DefaultConfigurationFactory(AbstractFactoryRegistry.class.getClassLoader());
        DefaultContainerFactory containerFactory = new DefaultContainerFactory(AbstractFactoryRegistry.class.getClassLoader());
        File containerWorkDir = FileUtil.createTmpDir(true);
        containerWorkDir.mkdirs();
        System.out.println("Container working directory: " + String.valueOf(containerWorkDir));
        LocalConfiguration configuration = (LocalConfiguration)configurationFactory.createConfiguration(containerId, ContainerType.INSTALLED, ConfigurationType.STANDALONE, containerWorkDir.getAbsolutePath());
        configuration.setProperty("cargo.servlet.port", Integer.toString(this.httpPort));
        configuration.setProperty("cargo.rmi.port", this.getPort());
        configuration.setProperty("cargo.glassfish.jms.port", this.getPort());
        configuration.setProperty("cargo.glassfish.orb.listener.port", this.getPort());
        configuration.setProperty("cargo.glassfish.http.ssl.port", this.getPort());
        configuration.setProperty("cargo.glassfish.orb.ssl.port", this.getPort());
        configuration.setProperty("cargo.glassfish.orb.mutualauth.port", this.getPort());
        configuration.setProperty("cargo.glassfish.domain.jmxPort", this.getPort());
        configuration.setProperty("cargo.glassfish.adminPort", this.getPort());
        if (containerId.startsWith("tomcat")) {
            configuration.setProperty("cargo.tomcat.ajp.port", this.getPort());
            if (Boolean.getBoolean("harness.useSSL")) {
                configuration.setProperty("cargo.protocol", "https");
                configuration.setProperty("cargo.tomcat.httpSecure", "true");
                configuration.setProperty("cargo.tomcat.connector.keystoreFile", new File(System.getProperty("harness.ssl.home"), "server-keystore.jks").getAbsolutePath());
                configuration.setProperty("cargo.tomcat.connector.keystorePass", "changeit");
                configuration.setProperty("cargo.tomcat.connector.keystoreType", "JKS");
                configuration.setProperty("cargo.tomcat.connector.truststoreFile", new File(System.getProperty("harness.ssl.home"), "server-truststore.jks").getAbsolutePath());
                configuration.setProperty("cargo.tomcat.connector.truststorePass", "changeit");
                configuration.setProperty("cargo.tomcat.connector.truststoreType", "JKS");
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        System.out.println("Warning: got: '" + urlHostName + "' expected '" + session.getPeerHost() + "'");
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
            }
        }
        this.container = (InstalledLocalContainer)containerFactory.createContainer(containerId, ContainerType.INSTALLED, (Configuration)configuration);
        ((InstalledLocalContainer)this.container).setHome(homeDir.getAbsolutePath());
        ((InstalledLocalContainer)this.container).setOutput(containerWorkDir.getAbsolutePath() + File.separatorChar + "server.log");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("WSIT_HOME", System.getProperty("WSIT_HOME"));
        ((InstalledLocalContainer)this.container).setSystemProperties(props);
        for (File f : World.runtime.list()) {
            if (f.getName().endsWith(".jar")) {
                ((InstalledLocalContainer)this.container).addExtraClasspath(f.getAbsolutePath());
                continue;
            }
            if (!"classes".equals(f.getName())) continue;
            String fName = f.getParentFile().getParentFile().getName();
            File jar = new File(new File(System.getProperty("java.io.tmpdir")), fName + System.currentTimeMillis() + ".jar");
            jar.deleteOnExit();
            Zip zip = new Zip();
            zip.setProject(new Project());
            zip.setDestFile(jar);
            zip.setBasedir(f);
            zip.execute();
            ((InstalledLocalContainer)this.container).addExtraClasspath(jar.getAbsolutePath());
        }
    }

    public String toString() {
        return "CargoLocalContainer:" + ((InstalledLocalContainer)this.container).getId();
    }

    private String getPort() {
        return String.valueOf(AbstractRunnableCargoContainer.getFreePort());
    }

    @Override
    protected WAR assembleWar(DeployedService service) throws Exception {
        WAR war = super.assembleWar(service);
        if (service.service.isSTS) {
            this.updateWsitClient(war, service, this.getServiceUrl(service.service.getGlobalUniqueName()).toExternalForm());
        }
        return war;
    }
}

