/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.cargo.gf;

import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.container.cargo.gf.GlassfishContainerCapability;
import com.sun.xml.ws.test.container.cargo.gf.GlassfishInstalledLocalDeployer;
import com.sun.xml.ws.test.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.util.CargoException;

public class GlassfishInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    private static final ContainerCapability CAPABILITY = new GlassfishContainerCapability();

    public GlassfishInstalledLocalContainer(LocalConfiguration localConfiguration) {
        super(localConfiguration);
    }

    void invokeAsAdmin(boolean async, String ... args) {
        File exec = this.getAsadminExecutable();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(exec.getAbsolutePath());
        for (String arg : args) {
            cmds.add(arg);
        }
        try {
            Execute exe = new Execute((ExecuteStreamHandler)new PumpStreamHandler(), new ExecuteWatchdog(30000L));
            exe.setAntRun(World.project);
            exe.setCommandline(cmds.toArray(new String[0]));
            if (async) {
                exe.spawn();
            } else {
                int exitCode = exe.execute();
                if (exitCode != 0) {
                    throw new CargoException(String.valueOf(cmds) + " failed. asadmin exited " + exitCode);
                }
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to invoke asadmin", (Throwable)e);
        }
    }

    private File getAsadminExecutable() {
        String home = this.getHome();
        if (home == null || !new File(home).exists()) {
            throw new CargoException("Glassfish home directory is not set");
        }
        File exec = File.pathSeparatorChar == ';' ? new File(new File(home), "bin/asadmin.bat") : new File(new File(home), "bin/asadmin");
        if (!exec.exists()) {
            throw new CargoException("asadmin command not found at " + String.valueOf(exec));
        }
        return exec;
    }

    protected void doStart(Java java) throws Exception {
        this.getConfiguration().configure((LocalContainer)this);
        System.out.println("Starting domain on HTTP port " + this.getConfiguration().getPropertyValue("cargo.servlet.port") + " and admin port " + this.getConfiguration().getPropertyValue("cargo.glassfish.adminPort"));
        this.invokeAsAdmin(true, "start-domain", "--interactive=false", "--domaindir", new File(this.getConfiguration().getHome()).getAbsolutePath(), "cargo-domain-" + this.getConfiguration().getPropertyValue("cargo.servlet.port"));
        Thread.sleep(20000L);
        GlassfishInstalledLocalDeployer deployer = new GlassfishInstalledLocalDeployer((InstalledLocalContainer)this);
        for (Deployable deployable : this.getConfiguration().getDeployables()) {
            deployer.deploy(deployable);
        }
    }

    protected void doStop(Java java) throws Exception {
        this.invokeAsAdmin(false, "stop-domain", "--domaindir", new File(this.getConfiguration().getHome()).getAbsolutePath(), "cargo-domain-" + this.getConfiguration().getPropertyValue("cargo.servlet.port"));
        FileUtil.deleteRecursive(new File(this.getConfiguration().getHome()));
    }

    public String getId() {
        return "glassfish1x";
    }

    public String getName() {
        return "Glassfish v1";
    }

    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    protected void doStart(JvmLauncher jl) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void doStop(JvmLauncher jl) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

