/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.cargo.gf;

import com.sun.xml.ws.test.Main;
import com.sun.xml.ws.test.container.cargo.gf.GlassfishInstalledLocalContainer;
import com.sun.xml.ws.test.container.cargo.gf.GlassfishStandaloneLocalConfigurationCapability;
import com.sun.xml.ws.test.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;

public class GlassfishStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new GlassfishStandaloneLocalConfigurationCapability();

    public GlassfishStandaloneLocalConfiguration(String home) {
        super(home);
        this.setProperty("cargo.remote.username", "admin");
        this.setProperty("cargo.remote.password", "adminadmin");
        this.setProperty("cargo.hostname", "localhost");
        this.setProperty("cargo.glassfish.adminPort", "4848");
        this.setProperty("cargo.glassfish.jms.port", "7676");
        this.setProperty("cargo.glassfish.orb.listener.port", "3700");
        this.setProperty("cargo.glassfish.http.ssl.port", "8181");
        this.setProperty("cargo.glassfish.orb.ssl.port", "3820");
        this.setProperty("cargo.glassfish.orb.mutualauth.port", "3920");
        this.setProperty("cargo.glassfish.domain.jmxPort", "8686");
    }

    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    File getPasswordFile() {
        return new File(this.getHome(), "password.properties");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        fileHandler.delete(this.getHome());
        String password = this.getPropertyValue("cargo.remote.password");
        if (password.length() < 8) {
            throw new CargoException("password needs to be 8 characters or longer");
        }
        new File(this.getHome()).mkdirs();
        FileWriter w = new FileWriter(this.getPasswordFile());
        w.write("AS_ADMIN_PASSWORD=" + password + "\n");
        w.write("AS_ADMIN_ADMINPASSWORD=" + password + "\n");
        w.close();
        ((GlassfishInstalledLocalContainer)container).invokeAsAdmin(false, "create-domain", "--interactive=false", "--adminport", this.getPropertyValue("cargo.glassfish.adminPort"), "--adminuser", this.getPropertyValue("cargo.remote.username"), "--passwordfile", this.getPasswordFile().getAbsolutePath(), "--instanceport", this.getPropertyValue("cargo.servlet.port"), "--domainproperties", this.getPropertyValueString("cargo.glassfish.jms.port") + ":" + this.getPropertyValueString("cargo.glassfish.orb.listener.port") + ":" + this.getPropertyValueString("cargo.glassfish.orb.ssl.port") + ":" + this.getPropertyValueString("cargo.glassfish.http.ssl.port") + ":" + this.getPropertyValueString("cargo.glassfish.orb.mutualauth.port") + ":" + this.getPropertyValueString("cargo.glassfish.domain.jmxPort"), "--template", "wsit-test-domain.xml.template", "--domaindir", new File(this.getHome()).getAbsolutePath(), "cargo-domain-" + this.getPropertyValue("cargo.servlet.port"));
        for (File src : Main.containerClasspathPrefix) {
            File dest = new File(this.getHome(), "cargo-domain-" + this.getPropertyValue("cargo.servlet.port") + "/lib/" + src.getName());
            FileUtil.copyFile(src, dest);
        }
        File cpcWar = new File(this.getHome(), "cargocpc.war");
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", cpcWar);
        this.getDeployables().add(new WAR(cpcWar.getAbsolutePath()));
    }

    private String getPropertyValueString(String key) {
        String value = this.getPropertyValue(key);
        return key.substring("cargo.glassfish.".length()) + "=" + value;
    }
}

