/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.gf;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.container.AbstractApplicationContainer;
import com.sun.xml.ws.test.container.Application;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.gf.GlassfishApplication;
import com.sun.xml.ws.test.tool.WsTool;
import java.io.File;
import java.net.URL;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public final class GlassfishContainer
extends AbstractApplicationContainer {
    private final DeploymentManager dm;
    private final Target[] targets;
    private final URL httpServerUrl;

    public GlassfishContainer(WsTool wsimport, WsTool wsgen, URL httpServerUrl, String host, int port, String userName, String password, boolean httpspi) throws Exception {
        super(wsimport, wsgen, httpspi);
        this.httpServerUrl = httpServerUrl;
        System.out.println("Connecting to Glassfish");
        String connectionUri = "deployer:Sun:AppServer::" + host + ":" + port;
        this.dm = null;
        if (this.dm == null) {
            throw new UnsupportedOperationException("TODO: FIX ME!!!");
        }
        this.targets = this.dm.getTargets();
        if (this.targets.length == 0) {
            throw new Exception("Can't find deployment targets for Glassfish");
        }
    }

    @Override
    public String getTransport() {
        return "http";
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void shutdown() throws Exception {
    }

    @Override
    @NotNull
    public Application deploy(DeployedService service) throws Exception {
        String contextPath = service.service.getGlobalUniqueName();
        File archive = new File(service.workDir, contextPath + ".war");
        this.createWARZip(service, archive);
        URL warURL = new URL(this.httpServerUrl, "/" + contextPath + "/");
        return new GlassfishApplication(warURL, service, this, this.deploy(archive, warURL));
    }

    private TargetModuleID[] deploy(File war, URL targetUrl) throws Exception {
        System.out.println("Deploying a service to " + String.valueOf(targetUrl));
        ProgressObject dpo = Monitor.join(this.dm.distribute(this.targets, war, null), "deployment failed");
        TargetModuleID[] modules = dpo.getResultTargetModuleIDs();
        Monitor.join(this.dm.start(modules), "failed to start services");
        return modules;
    }

    void undeploy(TargetModuleID[] modules, URL warURL) throws Exception {
        System.out.println("Undeploying a service from " + String.valueOf(warURL));
        Monitor.join(this.dm.undeploy(modules), "undeploy operation failed");
    }

    private static final class Monitor
    implements ProgressListener {
        private DeploymentStatus completionEvent;

        private Monitor() {
        }

        public static ProgressObject join(ProgressObject po, String errorMessage) throws Exception {
            Monitor m = new Monitor();
            po.addProgressListener((ProgressListener)m);
            m.join(errorMessage);
            return po;
        }

        public synchronized void handleProgressEvent(ProgressEvent event) {
            DeploymentStatus s = event.getDeploymentStatus();
            if (s.isFailed() || s.isCompleted()) {
                this.completionEvent = s;
                this.notifyAll();
            }
        }

        public synchronized void join(String errorMessage) throws Exception {
            while (this.completionEvent == null) {
                this.wait();
            }
            if (this.completionEvent.isFailed()) {
                throw new Exception(errorMessage + " : " + this.completionEvent.getMessage());
            }
        }
    }
}

