/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.invm;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.client.InterpreterEx;
import com.sun.xml.ws.test.container.Application;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.model.TestEndpoint;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

final class InVmApplication
implements Application {
    @NotNull
    private final WAR war;
    @NotNull
    private final URI baseEndpointAddress;
    @NotNull
    private final Object server;

    InVmApplication(@NotNull WAR war, Object server, URI endpointAddress) {
        this.war = war;
        this.server = server;
        this.baseEndpointAddress = endpointAddress;
    }

    @Override
    @NotNull
    public URI getEndpointAddress(@NotNull TestEndpoint endpoint) throws Exception {
        return this.baseEndpointAddress.resolve("?" + (endpoint.portName == null ? endpoint.name : endpoint.portName));
    }

    @Override
    @NotNull
    public List<URL> getWSDL() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File w : this.war.getWSDL()) {
            urls.add(w.toURL());
        }
        return urls;
    }

    @Override
    public void undeploy() throws Exception {
        InterpreterEx i = new InterpreterEx(this.server.getClass().getClassLoader());
        i.set("server", this.server);
        i.eval("server.undeploy()");
    }
}

