/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.exec;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import com.sun.xml.ws.test.CodeGenerator;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.client.InterpreterEx;
import com.sun.xml.ws.test.client.ScriptBaseClass;
import com.sun.xml.ws.test.client.XmlResource;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.DeploymentContext;
import com.sun.xml.ws.test.exec.Executor;
import com.sun.xml.ws.test.model.TestClient;
import com.sun.xml.ws.test.model.TestEndpoint;
import java.beans.Introspector;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientExecutor
extends Executor {
    private final TestClient client;
    private List<String> pImports = new ArrayList<String>();
    private StringBuilder pContents = new StringBuilder();
    private Map<String, String> varMap = new HashMap<String, String>();

    public ClientExecutor(DeploymentContext context, TestClient client) {
        super("client " + client.script.getName().replace('.', '_'), context);
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest() throws Throwable {
        CodeGenerator.testStarting(this.context.workDir);
        if (this.context.clientClassLoader == null) {
            this.context.clientClassLoader = this.context.getResources() != null ? new URLClassLoader(new URL[]{this.context.getResources().toURL()}, World.runtime.getClassLoader()) : World.runtime.getClassLoader();
        }
        InterpreterEx engine = new InterpreterEx(this.context.clientClassLoader);
        NameSpace ns = engine.getNameSpace();
        this.importPackage(ns, "jakarta.activation");
        this.importPackage(ns, "jakarta.xml.ws");
        this.importPackage(ns, "jakarta.xml.ws.soap");
        this.importPackage(ns, "jakarta.xml.ws.handler");
        this.importPackage(ns, "jakarta.xml.ws.handler.soap");
        this.importPackage(ns, "jakarta.xml.bind");
        this.importPackage(ns, "jakarta.xml.soap");
        this.importPackage(ns, "javax.xml.namespace");
        this.importPackage(ns, "javax.xml.transform");
        this.importPackage(ns, "javax.xml.transform.sax");
        this.importPackage(ns, "javax.xml.transform.dom");
        this.importPackage(ns, "javax.xml.transform.stream");
        this.importPackage(ns, "java.util");
        this.importPackage(ns, "java.util.concurrent");
        this.importPackage(ns, this.context.descriptor.name + ".client");
        if (this.context.descriptor.common != null && this.context.descriptor.common.exists()) {
            this.importPackage(ns, this.context.descriptor.name + ".common");
        }
        ns.importObject((Object)new ScriptBaseClass(this.context, engine, this.client));
        try {
            engine.eval(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("util.bsh")));
        }
        catch (EvalError evalError) {
            throw new Error("Failed to evaluate util.bsh", evalError);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.context.clientClassLoader);
        try {
            this.injectResources(ns, engine);
            this.invoke(engine);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    protected void importPackage(NameSpace ns, String p) {
        ns.importPackage(p);
        this.pImports.add(p + ".*");
    }

    protected void invoke(Interpreter engine) throws Throwable {
        try (Reader r = this.client.script.read();){
            if (this.client.parent.setUpScript != null) {
                engine.eval((Reader)new StringReader(this.client.parent.setUpScript), engine.getNameSpace(), "pre-client script");
                this.varMap.put("client_setUp_script", this.client.parent.setUpScript + "\n");
            } else {
                this.varMap.put("client_setUp_script", "");
            }
            CodeGenerator.generateClientClass(this.client.script.getName(), this.pImports, this.client.script.getSource(), this.varMap);
            engine.eval(r, engine.getNameSpace(), this.client.script.getName());
        }
    }

    private void injectResources(NameSpace ns, Interpreter engine) throws Exception {
        StringBuilder serviceList = new StringBuilder("injected services:");
        StringBuilder portList = new StringBuilder("injected ports:");
        StringBuilder addressList = new StringBuilder("injected addresses:");
        engine.set("home", (Object)this.client.parent.home);
        this.varMap.put("home", this.client.parent.home.toString());
        for (Map.Entry<String, XmlResource> e : this.context.descriptor.xmlResources.entrySet()) {
            engine.set(e.getKey(), (Object)e.getValue());
        }
        for (DeployedService svc : this.context.services.values()) {
            if (svc.service.isSTS) continue;
            engine.set("wsdlUrls", svc.app.getWSDL());
            for (Class clazz : svc.serviceClass) {
                String packageName = clazz.getPackage().getName();
                ns.importPackage(packageName);
                Method[] methods = clazz.getMethods();
                Class<Annotation> webendpointAnnotation = clazz.getClassLoader().loadClass("jakarta.xml.ws.WebEndpoint").asSubclass(Annotation.class);
                Method nameMethod = webendpointAnnotation.getDeclaredMethod("name", new Class[0]);
                Object serviceInstance = clazz.newInstance();
                String serviceVarName = Introspector.decapitalize(clazz.getSimpleName());
                engine.set(serviceVarName, serviceInstance);
                this.varMap.put("serviceClassName", clazz.getName().replaceAll("\\$", "."));
                this.varMap.put("serviceVarName", serviceVarName);
                serviceList.append(' ').append(serviceVarName);
                for (Method method : methods) {
                    Annotation endpoint = method.getAnnotation(webendpointAnnotation);
                    if (endpoint == null || method.getParameterTypes().length != 0) continue;
                    String portName = (String)nameMethod.invoke((Object)endpoint, new Object[0]);
                    String varName = Introspector.decapitalize(portName);
                    try {
                        engine.set(varName, method.invoke(serviceInstance, new Object[0]));
                        String portType = method.getReturnType().getName();
                        this.varMap.put("portType", portType);
                        this.varMap.put("getPortMethod", method.getName());
                        this.varMap.put("varName", varName);
                        this.varMap.put("serviceName", serviceVarName);
                        this.varMap.put("portName", portName);
                        String endpointAddress = svc.app.getEndpointAddress(this.getEndpoint(svc, portName)).toString();
                        engine.set(varName + "Address", (Object)endpointAddress);
                        addressList.append(' ').append(varName).append("Address");
                        this.varMap.put("address", endpointAddress);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof Exception) {
                            throw (Exception)e.getCause();
                        }
                        throw e;
                    }
                    portList.append(' ').append(varName);
                }
            }
        }
        System.out.println(serviceList);
        System.out.println(portList);
        System.out.println(addressList);
    }

    private TestEndpoint getEndpoint(DeployedService svc, String portName) {
        for (TestEndpoint e : svc.service.endpoints) {
            if (e.portName == null || !e.portName.equals(portName)) continue;
            return e;
        }
        if (svc.service.endpoints.size() != 1) {
            throw new Error("Multiple ports are defined on '" + svc.service.name + "', yet ports are ambiguous. Please use @WebService/Provider(portName=)");
        }
        return (TestEndpoint)svc.service.endpoints.toArray()[0];
    }
}

